/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.schema.mapping.BitemporalMapper;
import com.stratio.cassandra.lucene.search.condition.SingleMapperCondition;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;

public class BitemporalCondition
extends SingleMapperCondition<BitemporalMapper> {
    private static final Long DEFAULT_FROM = 0L;
    private static final Long DEFAULT_TO = Long.MAX_VALUE;
    final Object vtFrom;
    final Object vtTo;
    final Object ttFrom;
    final Object ttTo;

    public BitemporalCondition(Float boost, String field2, Object vtFrom, Object vtTo, Object ttFrom, Object ttTo) {
        super(boost, field2, BitemporalMapper.class);
        this.vtFrom = vtFrom;
        this.vtTo = vtTo;
        this.ttFrom = ttFrom;
        this.ttTo = ttTo;
    }

    @Override
    public Query doQuery(BitemporalMapper mapper, Analyzer analyzer) {
        Long vtFromTime = BitemporalCondition.parseTime(mapper, DEFAULT_FROM, this.vtFrom);
        Long vtToTime = BitemporalCondition.parseTime(mapper, DEFAULT_TO, this.vtTo);
        Long ttFromTime = BitemporalCondition.parseTime(mapper, DEFAULT_FROM, this.ttFrom);
        Long ttToTime = BitemporalCondition.parseTime(mapper, DEFAULT_TO, this.ttTo);
        Long minTime = BitemporalMapper.BitemporalDateTime.MIN.toTimestamp();
        Long maxTime = BitemporalMapper.BitemporalDateTime.MAX.toTimestamp();
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (!vtFromTime.equals(0L) || !vtToTime.equals(Long.MAX_VALUE)) {
            BooleanQuery.Builder validBuilder = new BooleanQuery.Builder();
            validBuilder.add(NumericRangeQuery.newLongRange(this.field + ".vtFrom", vtFromTime, vtToTime, true, true), BooleanClause.Occur.SHOULD);
            validBuilder.add(NumericRangeQuery.newLongRange(this.field + ".vtTo", vtFromTime, vtToTime, true, true), BooleanClause.Occur.SHOULD);
            BooleanQuery.Builder containsValidBuilder = new BooleanQuery.Builder();
            containsValidBuilder.add(NumericRangeQuery.newLongRange(this.field + ".vtFrom", minTime, vtFromTime, true, true), BooleanClause.Occur.MUST);
            containsValidBuilder.add(NumericRangeQuery.newLongRange(this.field + ".vtTo", vtToTime, maxTime, true, true), BooleanClause.Occur.MUST);
            validBuilder.add(containsValidBuilder.build(), BooleanClause.Occur.SHOULD);
            builder.add(validBuilder.build(), BooleanClause.Occur.MUST);
        }
        if (!ttFromTime.equals(0L) || !ttToTime.equals(Long.MAX_VALUE)) {
            BooleanQuery.Builder transactionBuilder = new BooleanQuery.Builder();
            transactionBuilder.add(NumericRangeQuery.newLongRange(this.field + ".ttFrom", ttFromTime, ttToTime, true, true), BooleanClause.Occur.SHOULD);
            transactionBuilder.add(NumericRangeQuery.newLongRange(this.field + ".ttTo", ttFromTime, ttToTime, true, true), BooleanClause.Occur.SHOULD);
            BooleanQuery.Builder containsTransactionBuilder = new BooleanQuery.Builder();
            containsTransactionBuilder.add(NumericRangeQuery.newLongRange(this.field + ".ttFrom", minTime, ttFromTime, true, true), BooleanClause.Occur.MUST);
            containsTransactionBuilder.add(NumericRangeQuery.newLongRange(this.field + ".ttTo", ttToTime, maxTime, true, true), BooleanClause.Occur.MUST);
            transactionBuilder.add(containsTransactionBuilder.build(), BooleanClause.Occur.SHOULD);
            builder.add(transactionBuilder.build(), BooleanClause.Occur.MUST);
        }
        return builder.build();
    }

    private static Long parseTime(BitemporalMapper mapper, Long defaultTime, Object value) {
        return value == null ? new BitemporalMapper.BitemporalDateTime(defaultTime).toTimestamp() : mapper.parseBitemporalDate(value).toTimestamp();
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return this.toStringHelper(this).add("vtFrom", this.vtFrom).add("vtTo", this.vtTo).add("ttFrom", this.ttFrom).add("ttTo", this.ttTo);
    }
}

