/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.search.condition.Condition;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanCondition
extends Condition {
    private static final Logger logger = LoggerFactory.getLogger(BooleanCondition.class);
    public final List<Condition> must;
    public final List<Condition> should;
    public final List<Condition> not;

    public BooleanCondition(Float boost, List<Condition> must, List<Condition> should, List<Condition> not) {
        super(boost);
        this.must = must == null ? Collections.EMPTY_LIST : must;
        this.should = should == null ? Collections.EMPTY_LIST : should;
        this.not = not == null ? Collections.EMPTY_LIST : not;
    }

    @Override
    public BooleanQuery doQuery(Schema schema) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        this.must.forEach(condition -> builder.add(condition.query(schema), BooleanClause.Occur.MUST));
        this.should.forEach(condition -> builder.add(condition.query(schema), BooleanClause.Occur.SHOULD));
        this.not.forEach(condition -> builder.add(condition.query(schema), BooleanClause.Occur.MUST_NOT));
        if (this.must.isEmpty() && this.should.isEmpty() && !this.not.isEmpty()) {
            logger.warn("Performing resource-intensive pure negation query {}", (Object)this);
            builder.add(new MatchAllDocsQuery(), BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    @Override
    public Set<String> postProcessingFields() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        this.must.forEach(condition -> fields.addAll(condition.postProcessingFields()));
        this.should.forEach(condition -> fields.addAll(condition.postProcessingFields()));
        return fields;
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return this.toStringHelper(this).add("must", this.must).add("should", this.should).add("not", this.not);
    }
}

