/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.schema.Schema;
import java.util.Set;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public abstract class Condition {
    public final Float boost;

    public Condition(Float boost) {
        this.boost = boost;
    }

    public final Query query(Schema schema) {
        Query query = this.doQuery(schema);
        return this.boost == null ? query : new BoostQuery(query, this.boost.floatValue());
    }

    protected abstract Query doQuery(Schema var1);

    public abstract Set<String> postProcessingFields();

    static BytesRef docValue(String value) {
        return value == null ? null : new BytesRef(value);
    }

    static Long docValue(Long value) {
        return value == null ? null : value;
    }

    static Long docValue(Integer value) {
        return value == null ? null : Long.valueOf(value.longValue());
    }

    static Long docValue(Float value) {
        return value == null ? null : Condition.docValue(NumericUtils.floatToSortableInt(value.floatValue()));
    }

    static Long docValue(Double value) {
        return value == null ? null : Long.valueOf(NumericUtils.doubleToSortableLong(value));
    }

    protected MoreObjects.ToStringHelper toStringHelper(Object o) {
        return MoreObjects.toStringHelper((Object)o).add("boost", (Object)this.boost);
    }

    protected abstract MoreObjects.ToStringHelper toStringHelper();

    public String toString() {
        return this.toStringHelper().toString();
    }
}

