/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import com.stratio.cassandra.lucene.search.condition.MatchCondition;
import com.stratio.cassandra.lucene.search.condition.SingleColumnCondition;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class ContainsCondition
extends SingleColumnCondition {
    public static final boolean DEFAULT_DOC_VALUES = false;
    public final String field;
    public final Object[] values;
    public final boolean docValues;

    public ContainsCondition(Float boost, String field2, Boolean docValues, Object ... values) {
        super(boost, field2);
        if (values == null || values.length == 0) {
            throw new IndexException("Field values required");
        }
        this.field = field2;
        this.values = values;
        this.docValues = docValues == null ? false : docValues;
    }

    @Override
    public Query doQuery(SingleColumnMapper<?> mapper, Analyzer analyzer) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Object value : this.values) {
            MatchCondition condition = new MatchCondition(null, this.field, value, this.docValues);
            builder.add(condition.doQuery(mapper, analyzer), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return this.toStringHelper(this).add("values", (Object)Arrays.toString(this.values)).add("docValues", this.docValues);
    }
}

