/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.DateRangeMapper;
import com.stratio.cassandra.lucene.search.condition.SingleMapperCondition;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.prefix.NumberRangePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.NumberRangePrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;

public class DateRangeCondition
extends SingleMapperCondition<DateRangeMapper> {
    public static final Date DEFAULT_FROM = new Date(Long.MIN_VALUE);
    public static final Date DEFAULT_TO = new Date(Long.MAX_VALUE);
    public static final String DEFAULT_OPERATION = "intersects";
    public final Object from;
    public final Object to;
    public final String operation;

    public DateRangeCondition(Float boost, String field2, Object from, Object to, String operation) {
        super(boost, field2, DateRangeMapper.class);
        this.from = from == null ? DEFAULT_FROM : from;
        this.to = to == null ? DEFAULT_TO : to;
        this.operation = operation == null ? DEFAULT_OPERATION : operation;
    }

    @Override
    public Query doQuery(DateRangeMapper mapper, Analyzer analyzer) {
        NumberRangePrefixTreeStrategy strategy = mapper.strategy;
        Date fromDate = mapper.base(this.from);
        Date toDate = mapper.base(this.to);
        NumberRangePrefixTree.NRShape shape = mapper.makeShape(fromDate, toDate);
        SpatialOperation spatialOperation = DateRangeCondition.parseSpatialOperation(this.operation);
        SpatialArgs args = new SpatialArgs(spatialOperation, shape);
        return ((SpatialStrategy)strategy).makeQuery(args);
    }

    static SpatialOperation parseSpatialOperation(String operation) {
        if (operation == null) {
            throw new IndexException("Operation is required");
        }
        if (operation.equalsIgnoreCase("is_within")) {
            return SpatialOperation.IsWithin;
        }
        if (operation.equalsIgnoreCase("contains")) {
            return SpatialOperation.Contains;
        }
        if (operation.equalsIgnoreCase(DEFAULT_OPERATION)) {
            return SpatialOperation.Intersects;
        }
        throw new IndexException("Operation is invalid: {}", (Object)operation);
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return this.toStringHelper(this).add("from", this.from).add("to", this.to).add("operation", (Object)this.operation);
    }
}

