/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.MoreObjects;
import com.spatial4j.core.shape.Rectangle;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.common.GeospatialUtils;
import com.stratio.cassandra.lucene.schema.mapping.GeoPointMapper;
import com.stratio.cassandra.lucene.search.condition.SingleMapperCondition;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;

public class GeoBBoxCondition
extends SingleMapperCondition<GeoPointMapper> {
    public final double minLatitude;
    public final double maxLatitude;
    public final double minLongitude;
    public final double maxLongitude;

    public GeoBBoxCondition(Float boost, String field2, Double minLatitude, Double maxLatitude, Double minLongitude, Double maxLongitude) {
        super(boost, field2, GeoPointMapper.class);
        this.minLatitude = GeospatialUtils.checkLatitude("min_latitude", minLatitude);
        this.maxLatitude = GeospatialUtils.checkLatitude("max_latitude", maxLatitude);
        this.minLongitude = GeospatialUtils.checkLongitude("min_longitude", minLongitude);
        this.maxLongitude = GeospatialUtils.checkLongitude("max_longitude", maxLongitude);
        if (minLongitude > maxLongitude) {
            throw new IndexException("min_longitude must be lower than max_longitude");
        }
        if (minLatitude > maxLatitude) {
            throw new IndexException("min_latitude must be lower than max_latitude");
        }
    }

    @Override
    public Query doQuery(GeoPointMapper mapper, Analyzer analyzer) {
        Rectangle rectangle = GeospatialUtils.CONTEXT.makeRectangle(this.minLongitude, this.maxLongitude, this.minLatitude, this.maxLatitude);
        SpatialArgs args = new SpatialArgs(SpatialOperation.Intersects, rectangle);
        return mapper.strategy.makeQuery(args);
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return this.toStringHelper(this).add("minLatitude", this.minLatitude).add("maxLatitude", this.maxLatitude).add("minLongitude", this.minLongitude).add("maxLongitude", this.maxLongitude);
    }
}

