/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.common.GeoOperation;
import com.stratio.cassandra.lucene.common.GeoShape;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.mapping.GeoPointMapper;
import com.stratio.cassandra.lucene.schema.mapping.GeoShapeMapper;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.search.condition.SingleFieldCondition;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.composite.CompositeSpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;

public class GeoShapeCondition
extends SingleFieldCondition {
    public static final GeoOperation DEFAULT_OPERATION = GeoOperation.IS_WITHIN;
    public final GeoShape shape;
    public final GeoOperation operation;

    public GeoShapeCondition(Float boost, String field2, GeoShape shape, GeoOperation operation) {
        super(boost, field2);
        if (shape == null) {
            throw new IndexException("Shape required");
        }
        this.shape = shape;
        this.operation = operation == null ? DEFAULT_OPERATION : operation;
    }

    @Override
    public Query doQuery(Schema schema) {
        CompositeSpatialStrategy strategy;
        Mapper mapper = schema.mapper(this.field);
        if (mapper == null) {
            throw new IndexException("No mapper found for field '{}'", (Object)this.field);
        }
        if (mapper instanceof GeoShapeMapper) {
            strategy = ((GeoShapeMapper)mapper).strategy;
        } else if (mapper instanceof GeoPointMapper) {
            strategy = ((GeoPointMapper)mapper).strategy;
        } else {
            throw new IndexException("'geo_shape' search requires a mapper of type 'geo_point' or 'geo_shape' but found {}:{}", (Object)this.field, (Object)mapper);
        }
        SpatialArgs args = new SpatialArgs(this.operation.getSpatialOperation(), this.shape.apply());
        args.setDistErr(0.0);
        return ((SpatialStrategy)strategy).makeQuery(args);
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return this.toStringHelper(this).add("shape", (Object)this.shape).add("operation", (Object)this.operation);
    }
}

