/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.SchemaAnalyzer;
import com.stratio.cassandra.lucene.search.condition.Condition;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;

public class LuceneCondition
extends Condition {
    public static final String DEFAULT_FIELD = "lucene";
    public final String query;
    public final String defaultField;

    public LuceneCondition(Float boost, String defaultField, String query) {
        super(boost);
        if (StringUtils.isBlank((CharSequence)query)) {
            throw new IndexException("Query statement required");
        }
        this.query = query;
        this.defaultField = defaultField == null ? DEFAULT_FIELD : defaultField;
    }

    @Override
    public Set<String> postProcessingFields() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        if (!StringUtils.isBlank((CharSequence)this.defaultField)) {
            fields.add(this.defaultField);
        }
        for (String term : this.query.split("[ ]")) {
            if (!term.contains(":")) continue;
            fields.add(term.split(":")[0]);
        }
        return fields;
    }

    @Override
    public Query doQuery(Schema schema) {
        try {
            SchemaAnalyzer analyzer = schema.analyzer;
            QueryParser queryParser = new QueryParser(this.defaultField, analyzer);
            queryParser.setAllowLeadingWildcard(true);
            queryParser.setLowercaseExpandedTerms(false);
            return queryParser.parse(this.query);
        }
        catch (ParseException e) {
            throw new IndexException("Error while parsing lucene syntax query: {}", (Object)e.getMessage());
        }
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return this.toStringHelper(this).add("query", (Object)this.query).add("defaultField", (Object)this.defaultField);
    }
}

