/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import com.stratio.cassandra.lucene.schema.mapping.TextMapper;
import com.stratio.cassandra.lucene.search.condition.SingleColumnCondition;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocValuesNumbersQuery;
import org.apache.lucene.search.DocValuesTermsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.QueryBuilder;

public class MatchCondition
extends SingleColumnCondition {
    public static final boolean DEFAULT_DOC_VALUES = false;
    public final Object value;
    public final boolean docValues;

    public MatchCondition(Float boost, String field2, Object value, Boolean docValues) {
        super(boost, field2);
        if (value == null) {
            throw new IndexException("Field value required");
        }
        this.value = value;
        this.docValues = docValues == null ? false : docValues;
    }

    @Override
    public Query doQuery(SingleColumnMapper<?> mapper, Analyzer analyzer) {
        Query query;
        if (this.docValues && !mapper.docValues.booleanValue()) {
            throw new IndexException("Field '{}' does not support doc_values", (Object)mapper.field);
        }
        Class clazz = mapper.base;
        if (clazz == String.class) {
            String base = (String)mapper.base(this.field, this.value);
            if (mapper instanceof TextMapper) {
                QueryBuilder queryBuilder = new QueryBuilder(analyzer);
                query = queryBuilder.createPhraseQuery(this.field, base, 0);
            } else {
                query = this.query(base);
            }
            if (query == null) {
                query = new BooleanQuery.Builder().build();
            }
        } else if (clazz == Integer.class) {
            query = this.query((Integer)mapper.base(this.field, this.value));
        } else if (clazz == Long.class) {
            query = this.query((Long)mapper.base(this.field, this.value));
        } else if (clazz == Float.class) {
            query = this.query((Float)mapper.base(this.field, this.value));
        } else if (clazz == Double.class) {
            query = this.query((Double)mapper.base(this.field, this.value));
        } else {
            throw new IndexException("Match queries are not supported by mapper '{}'", mapper);
        }
        return query;
    }

    private Query query(String value) {
        return this.docValues ? new DocValuesTermsQuery(this.field, value) : new TermQuery(new Term(this.field, value));
    }

    private Query query(Integer value) {
        if (this.docValues) {
            return new DocValuesNumbersQuery(this.field, MatchCondition.docValue(value));
        }
        BytesRefBuilder ref = new BytesRefBuilder();
        NumericUtils.intToPrefixCoded(value, 0, ref);
        return new TermQuery(new Term(this.field, ref.toBytesRef()));
    }

    private Query query(Long value) {
        if (this.docValues) {
            return new DocValuesNumbersQuery(this.field, MatchCondition.docValue(value));
        }
        BytesRefBuilder ref = new BytesRefBuilder();
        NumericUtils.longToPrefixCoded(value, 0, ref);
        return new TermQuery(new Term(this.field, ref.toBytesRef()));
    }

    private Query query(Float value) {
        return this.docValues ? new DocValuesNumbersQuery(this.field, MatchCondition.docValue(value)) : NumericRangeQuery.newFloatRange(this.field, value, value, true, true);
    }

    private Query query(Double value) {
        return this.docValues ? new DocValuesNumbersQuery(this.field, MatchCondition.docValue(value)) : NumericRangeQuery.newDoubleRange(this.field, value, value, true, true);
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return this.toStringHelper(this).add("value", this.value).add("docValues", this.docValues);
    }
}

