/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import com.stratio.cassandra.lucene.search.condition.SingleColumnCondition;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.QueryBuilder;

public class PhraseCondition
extends SingleColumnCondition {
    public static final int DEFAULT_SLOP = 0;
    public final String value;
    public final int slop;

    public PhraseCondition(Float boost, String field2, String value, Integer slop) {
        super(boost, field2);
        if (value == null) {
            throw new IndexException("Field value required");
        }
        if (slop != null && slop < 0) {
            throw new IndexException("Slop must be positive");
        }
        this.value = value;
        this.slop = slop == null ? 0 : slop;
    }

    @Override
    public Query doQuery(SingleColumnMapper<?> mapper, Analyzer analyzer) {
        if (mapper.base == String.class) {
            QueryBuilder queryBuilder = new QueryBuilder(analyzer);
            Query query = queryBuilder.createPhraseQuery(this.field, this.value, this.slop);
            if (query == null) {
                query = new BooleanQuery.Builder().build();
            }
            return query;
        }
        throw new IndexException("Phrase queries are not supported by mapper '{}'", mapper);
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return this.toStringHelper(this).add("value", (Object)this.value).add("slop", this.slop);
    }
}

