/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import com.stratio.cassandra.lucene.search.condition.SingleColumnCondition;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.DocValuesRangeQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;

public class RangeCondition
extends SingleColumnCondition {
    public static final boolean DEFAULT_INCLUDE_LOWER = false;
    public static final boolean DEFAULT_INCLUDE_UPPER = false;
    public static final boolean DEFAULT_DOC_VALUES = false;
    public final Object lower;
    public final Object upper;
    public final boolean includeLower;
    public final boolean includeUpper;
    public final boolean docValues;

    public RangeCondition(Float boost, String field2, Object lowerValue, Object upperValue, Boolean includeLower, Boolean includeUpper, Boolean docValues) {
        super(boost, field2);
        this.lower = lowerValue;
        this.upper = upperValue;
        this.includeLower = includeLower == null ? false : includeLower;
        this.includeUpper = includeUpper == null ? false : includeUpper;
        this.docValues = docValues == null ? false : docValues;
    }

    @Override
    public Query doQuery(SingleColumnMapper<?> mapper, Analyzer analyzer) {
        Query query;
        if (this.docValues && !mapper.docValues.booleanValue()) {
            throw new IndexException("Field '{}' does not support doc_values", (Object)mapper.field);
        }
        Class clazz = mapper.base;
        if (clazz == String.class) {
            String start = (String)mapper.base(this.field, this.lower);
            String stop = (String)mapper.base(this.field, this.upper);
            query = this.query(start, stop);
        } else if (clazz == Integer.class) {
            Integer start = (Integer)mapper.base(this.field, this.lower);
            Integer stop = (Integer)mapper.base(this.field, this.upper);
            query = this.query(start, stop);
        } else if (clazz == Long.class) {
            Long start = (Long)mapper.base(this.field, this.lower);
            Long stop = (Long)mapper.base(this.field, this.upper);
            query = this.query(start, stop);
        } else if (clazz == Float.class) {
            Float start = (Float)mapper.base(this.field, this.lower);
            Float stop = (Float)mapper.base(this.field, this.upper);
            query = this.query(start, stop);
        } else if (clazz == Double.class) {
            Double start = (Double)mapper.base(this.field, this.lower);
            Double stop = (Double)mapper.base(this.field, this.upper);
            query = this.query(start, stop);
        } else {
            throw new IndexException("Range queries are not supported by mapper '{}'", mapper);
        }
        return query;
    }

    private Query query(String start, String stop) {
        return this.docValues ? DocValuesRangeQuery.newBytesRefRange(this.field, RangeCondition.docValue(start), RangeCondition.docValue(stop), this.includeLower, this.includeUpper) : TermRangeQuery.newStringRange(this.field, start, stop, this.includeLower, this.includeUpper);
    }

    private Query query(Integer start, Integer stop) {
        return this.docValues ? DocValuesRangeQuery.newLongRange(this.field, RangeCondition.docValue(start), RangeCondition.docValue(stop), this.includeLower, this.includeUpper) : NumericRangeQuery.newIntRange(this.field, start, stop, this.includeLower, this.includeUpper);
    }

    private Query query(Long start, Long stop) {
        return this.docValues ? DocValuesRangeQuery.newLongRange(this.field, RangeCondition.docValue(start), RangeCondition.docValue(stop), this.includeLower, this.includeUpper) : NumericRangeQuery.newLongRange(this.field, start, stop, this.includeLower, this.includeUpper);
    }

    private Query query(Float start, Float stop) {
        return this.docValues ? DocValuesRangeQuery.newLongRange(this.field, RangeCondition.docValue(start), RangeCondition.docValue(stop), this.includeLower, this.includeUpper) : NumericRangeQuery.newFloatRange(this.field, start, stop, this.includeLower, this.includeUpper);
    }

    private Query query(Double start, Double stop) {
        return this.docValues ? DocValuesRangeQuery.newLongRange(this.field, RangeCondition.docValue(start), RangeCondition.docValue(stop), this.includeLower, this.includeUpper) : NumericRangeQuery.newDoubleRange(this.field, start, stop, this.includeLower, this.includeUpper);
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return this.toStringHelper(this).add("lower", this.lower).add("upper", this.upper).add("includeLower", this.includeLower).add("includeUpper", this.includeUpper).add("docValues", this.docValues);
    }
}

