/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.search.condition.SingleFieldCondition;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;

public abstract class SingleMapperCondition<T extends Mapper>
extends SingleFieldCondition {
    protected final Class<? extends T> type;

    protected SingleMapperCondition(Float boost, String field2, Class<? extends T> type) {
        super(boost, field2);
        this.type = type;
    }

    @Override
    public final Query doQuery(Schema schema) {
        Mapper mapper = schema.mapper(this.field);
        if (mapper == null) {
            throw new IndexException("No mapper found for field '{}'", (Object)this.field);
        }
        if (!this.type.isAssignableFrom(mapper.getClass())) {
            throw new IndexException("Field '{}' requires a mapper of type '{}' but found '{}'", (Object)this.field, this.type, (Object)mapper);
        }
        return this.doQuery(mapper, schema.analyzer);
    }

    public abstract Query doQuery(T var1, Analyzer var2);
}

