/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import com.stratio.cassandra.lucene.search.condition.SingleColumnCondition;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;

public class WildcardCondition
extends SingleColumnCondition {
    public final String value;

    public WildcardCondition(Float boost, String field2, String value) {
        super(boost, field2);
        if (value == null) {
            throw new IndexException("Field value required");
        }
        this.value = value;
    }

    @Override
    public Query doQuery(SingleColumnMapper<?> mapper, Analyzer analyzer) {
        if (mapper.base == String.class) {
            Term term = new Term(this.field, this.value);
            return new WildcardQuery(term);
        }
        throw new IndexException("Wildcard queries are not supported by mapper '{}'", mapper);
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return this.toStringHelper(this).add("value", (Object)this.value);
    }
}

