/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.condition.builder;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stratio.cassandra.lucene.common.GeoDistance;
import com.stratio.cassandra.lucene.search.condition.GeoDistanceCondition;
import com.stratio.cassandra.lucene.search.condition.builder.ConditionBuilder;

public class GeoDistanceConditionBuilder
extends ConditionBuilder<GeoDistanceCondition, GeoDistanceConditionBuilder> {
    @JsonProperty(value="field")
    private final String field;
    @JsonProperty(value="latitude")
    private final double latitude;
    @JsonProperty(value="longitude")
    private final double longitude;
    @JsonProperty(value="max_distance")
    private final String maxDistance;
    @JsonProperty(value="min_distance")
    private String minDistance;

    @JsonCreator
    public GeoDistanceConditionBuilder(@JsonProperty(value="field") String field2, @JsonProperty(value="latitude") double latitude, @JsonProperty(value="longitude") double longitude, @JsonProperty(value="max_distance") String maxDistance) {
        this.field = field2;
        this.longitude = longitude;
        this.latitude = latitude;
        this.maxDistance = maxDistance;
    }

    public GeoDistanceConditionBuilder setMinDistance(String minDistance) {
        this.minDistance = minDistance;
        return this;
    }

    @Override
    public GeoDistanceCondition build() {
        GeoDistance min = this.minDistance == null ? null : GeoDistance.parse(this.minDistance);
        GeoDistance max = this.maxDistance == null ? null : GeoDistance.parse(this.maxDistance);
        return new GeoDistanceCondition(this.boost, this.field, this.latitude, this.longitude, min, max);
    }
}

