/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.sort;

import com.google.common.base.MoreObjects;
import com.spatial4j.core.shape.Point;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.common.GeospatialUtils;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.mapping.GeoPointMapper;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.search.sort.SortField;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.serialized.SerializedDVStrategy;

public class GeoDistanceSortField
extends SortField {
    public final String field;
    public final double latitude;
    public final double longitude;

    public GeoDistanceSortField(String field2, Boolean reverse, double latitude, double longitude) {
        super(reverse);
        if (field2 == null || StringUtils.isBlank((CharSequence)field2)) {
            throw new IndexException("Field name required");
        }
        this.field = field2;
        this.latitude = GeospatialUtils.checkLatitude("latitude", latitude);
        this.longitude = GeospatialUtils.checkLongitude("longitude", longitude);
    }

    @Override
    public org.apache.lucene.search.SortField sortField(Schema schema) {
        Mapper mapper = schema.mapper(this.field);
        if (mapper == null) {
            throw new IndexException("Field '{}' is not found", (Object)this.field);
        }
        if (!(mapper instanceof GeoPointMapper)) {
            throw new IndexException("Field '{}' type is not geo_point", (Object)this.field);
        }
        GeoPointMapper geoPointMapper = (GeoPointMapper)mapper;
        Point point = GeospatialUtils.CONTEXT.makePoint(this.longitude, this.latitude);
        SerializedDVStrategy strategy = geoPointMapper.strategy.getGeometryStrategy();
        ValueSource valueSource = ((SpatialStrategy)strategy).makeDistanceValueSource(point, 111.19507973436875);
        return valueSource.getSortField(this.reverse);
    }

    @Override
    public Set<String> postProcessingFields() {
        return Collections.singleton(this.field);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("field", (Object)this.field).add("reverse", this.reverse).add("latitude", this.latitude).add("longitude", this.longitude).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoDistanceSortField other = (GeoDistanceSortField)o;
        return this.reverse == other.reverse && this.field.equals(other.field) && this.latitude == other.latitude && this.longitude == other.longitude;
    }

    @Override
    public int hashCode() {
        int result2 = this.field.hashCode();
        result2 = 31 * result2 + (this.reverse ? 1 : 0);
        result2 = 31 * result2 + new Double(this.latitude).hashCode();
        result2 = 31 * result2 + new Double(this.longitude).hashCode();
        return result2;
    }
}

