/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search.sort;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.search.sort.SortField;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SimpleSortField
extends SortField {
    public final String field;

    public SimpleSortField(String field2, Boolean reverse) {
        super(reverse);
        if (field2 == null || StringUtils.isBlank((CharSequence)field2)) {
            throw new IndexException("Field name required");
        }
        this.field = field2;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public org.apache.lucene.search.SortField sortField(Schema schema) {
        if (this.field.equalsIgnoreCase("score")) {
            return org.apache.lucene.search.SortField.FIELD_SCORE;
        }
        Mapper mapper = schema.mapper(this.field);
        if (mapper == null) {
            throw new IndexException("No mapper found for sortFields field '{}'", (Object)this.field);
        }
        if (!mapper.docValues.booleanValue()) {
            throw new IndexException("Field '{}' does not support sorting", (Object)this.field);
        }
        return mapper.sortField(this.field, this.reverse);
    }

    @Override
    public Set<String> postProcessingFields() {
        return Collections.singleton(this.field);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("field", (Object)this.field).add("reverse", this.reverse).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSortField otherSimpleSortField = (SimpleSortField)o;
        return this.reverse == otherSimpleSortField.reverse && this.field.equals(otherSimpleSortField.field);
    }

    @Override
    public int hashCode() {
        int result2 = this.field.hashCode();
        result2 = 31 * result2 + (this.reverse ? 1 : 0);
        return result2;
    }
}

