/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.util;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Hex;
import org.apache.lucene.util.BytesRef;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction2$mcIII$sp;

public final class ByteBufferUtils$ {
    public static ByteBufferUtils$ MODULE$;

    static {
        new ByteBufferUtils$();
    }

    public ByteBuffer compose(ByteBuffer ... bbs) {
        return this.compose(Predef$.MODULE$.wrapRefArray((Object[])bbs));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] asArray(ByteBuffer bb) {
        void var3_3;
        ByteBuffer duplicate = bb.duplicate();
        byte[] bytes = new byte[duplicate.remaining()];
        duplicate.get(bytes);
        return var3_3;
    }

    public boolean isEmpty(ByteBuffer byteBuffer) {
        return byteBuffer.remaining() == 0;
    }

    public ByteBuffer[] split(ByteBuffer byteBuffer, AbstractType<?> type) {
        ByteBuffer[] byteBufferArray;
        AbstractType<?> abstractType = type;
        if (abstractType instanceof CompositeType) {
            CompositeType compositeType = (CompositeType)abstractType;
            byteBufferArray = compositeType.split(byteBuffer);
        } else {
            byteBufferArray = (ByteBuffer[])((Object[])new ByteBuffer[]{byteBuffer});
        }
        return byteBufferArray;
    }

    public String toHex(ByteBuffer byteBuffer) {
        return byteBuffer == null ? null : ByteBufferUtil.bytesToHex((ByteBuffer)byteBuffer);
    }

    public String toHex(BytesRef bytesRef) {
        return ByteBufferUtil.bytesToHex((ByteBuffer)this.byteBuffer(bytesRef));
    }

    public String toHex(Seq<Object> bytes) {
        return this.toHex((byte[])bytes.toArray(ClassTag$.MODULE$.Byte()));
    }

    public String toHex(byte[] bytes) {
        return Hex.bytesToHex((byte[])bytes, (int)0, (int)bytes.length);
    }

    public String toHex(byte b) {
        return Hex.bytesToHex((byte[])new byte[]{b});
    }

    public BytesRef bytesRef(ByteBuffer bb) {
        return new BytesRef(this.asArray(bb));
    }

    public ByteBuffer byteBuffer(BytesRef bytesRef) {
        return ByteBuffer.wrap(bytesRef.bytes, bytesRef.offset, bytesRef.offset + bytesRef.length);
    }

    public ByteBuffer byteBuffer(String hex) {
        return hex == null ? null : ByteBufferUtil.hexToBytes((String)hex);
    }

    public ByteBuffer compose(Seq<ByteBuffer> bbs) {
        int n = 2;
        int totalLength = BoxesRunTime.unboxToInt(((TraversableOnce)bbs.map((Function1<ByteBuffer, Object> & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.remaining()), Seq$.MODULE$.canBuildFrom())).$div$colon(BoxesRunTime.boxToInteger(n), (JFunction2$mcIII$sp & Serializable)(x$3, x$4) -> x$3 + x$4 + 2));
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        ByteBufferUtil.writeShortLength((ByteBuffer)out, (int)bbs.length());
        bbs.foreach((Function1<ByteBuffer, ByteBuffer> & java.io.Serializable & Serializable)bb -> {
            ByteBufferUtil.writeShortLength((ByteBuffer)out, (int)bb.remaining());
            return out.put(bb.duplicate());
        });
        out.flip();
        return out;
    }

    public ByteBuffer[] decompose(ByteBuffer bb) {
        ByteBuffer duplicate = bb.duplicate();
        int numComponents = ByteBufferUtil.readShortLength((ByteBuffer)duplicate);
        return (ByteBuffer[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numComponents).map((Function1<Object, ByteBuffer> & java.io.Serializable & Serializable)x$5 -> ByteBufferUtils$.$anonfun$decompose$1(duplicate, BoxesRunTime.unboxToInt(x$5)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ByteBuffer.class));
    }

    public static final /* synthetic */ ByteBuffer $anonfun$decompose$1(ByteBuffer duplicate$1, int x$5) {
        int componentLength = ByteBufferUtil.readShortLength((ByteBuffer)duplicate$1);
        return ByteBufferUtil.readBytes((ByteBuffer)duplicate$1, (int)componentLength);
    }

    private ByteBufferUtils$() {
        MODULE$ = this;
    }
}

