/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.util;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.column.Column;
import com.stratio.cassandra.lucene.column.Column$;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LexicalUUIDType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.UserType;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;

public final class SchemaValidator$ {
    public static SchemaValidator$ MODULE$;
    private final Logger logger;

    static {
        new SchemaValidator$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void validate(Schema schema, CFMetaData metadata) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(schema.mappers.values()).asScala()).foreach((Function1<Mapper, Object> & Serializable & scala.Serializable)mapper -> {
            SchemaValidator$.$anonfun$validate$1(this, metadata, mapper);
            return BoxedUnit.UNIT;
        });
    }

    public void validate(CFMetaData metadata, String column, String field2, List<Class<?>> supportedTypes, List<Class<?>> excludedTypes, boolean supportsCollections) {
        String cellName = Column$.MODULE$.parseCellName(column);
        ColumnDefinition cellDefinition = metadata.getColumnDefinition(UTF8Type.instance.decompose((Object)cellName));
        if (cellDefinition == null) {
            throw new IndexException("No column definition '{}' for mapper '{}'", (Object)cellName, (Object)field2);
        }
        if (cellDefinition.isStatic()) {
            throw new IndexException("Lucene indexes are not allowed on static columns as '{}'", (Object)column);
        }
        AbstractType cellType = cellDefinition.type;
        cellType.isCollection();
        List<String> udtNames = Column$.MODULE$.parseUdtNames(column);
        if (udtNames.isEmpty()) {
            this.checkSupported$1(cellType, cellName, supportsCollections, field2, supportedTypes, excludedTypes);
        } else {
            ObjectRef<Column> column2 = ObjectRef.create(Column$.MODULE$.apply(cellName));
            ObjectRef<AbstractType> currentType = ObjectRef.create(cellType);
            udtNames.indices().foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
                column$1.elem = ((Column)column$1.elem).withUDTName((String)udtNames.apply(i));
                boolean bl = false;
                Some some = null;
                Option<AbstractType<?>> option = this.childType((AbstractType)currentType$1.elem, (String)udtNames.apply(i));
                if (None$.MODULE$.equals(option)) {
                    throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No column definition '", "' for field '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{((Column)column$1.elem).mapper(), field2})));
                }
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    AbstractType n = (AbstractType)some.value();
                    if (i == udtNames.indices().last()) {
                        this.checkSupported$1(n, ((Column)column$1.elem).mapper(), supportsCollections, field2, supportedTypes, excludedTypes);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                if (!bl) throw new MatchError(option);
                AbstractType n = (AbstractType)some.value();
                currentType$1.elem = n;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }
    }

    public Option<AbstractType<?>> childType(AbstractType<?> parent, String child) {
        Option option;
        block12: {
            AbstractType abstractType;
            while (true) {
                boolean bl = false;
                MapType mapType = null;
                abstractType = parent;
                if (abstractType instanceof ReversedType) {
                    ReversedType reversedType = (ReversedType)abstractType;
                    parent = reversedType.baseType;
                    continue;
                }
                if (abstractType instanceof SetType) {
                    SetType setType = (SetType)abstractType;
                    parent = setType.nameComparator();
                    continue;
                }
                if (abstractType instanceof ListType) {
                    ListType listType = (ListType)abstractType;
                    parent = listType.valueComparator();
                    continue;
                }
                if (abstractType instanceof MapType) {
                    bl = true;
                    mapType = (MapType)abstractType;
                    String string = child;
                    String string2 = Column$.MODULE$.MAP_KEY_SUFFIX();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        option = new Some<AbstractType>(mapType.getKeysType());
                        break block12;
                    }
                }
                if (bl) {
                    String string = child;
                    String string3 = Column$.MODULE$.MAP_VALUE_SUFFIX();
                    if (!(string != null ? !string.equals(string3) : string3 != null)) {
                        option = new Some<AbstractType>(mapType.valueComparator());
                        break block12;
                    }
                }
                if (!bl) break;
                parent = mapType.valueComparator();
            }
            if (abstractType instanceof UserType) {
                UserType userType = (UserType)abstractType;
                option = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), userType.fieldNames().size()).find((JFunction1$mcZI$sp & scala.Serializable)x$1 -> {
                    String string = userType.fieldNameAsString(x$1);
                    String string2 = child;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }).map((Function1<Object, AbstractType> & Serializable & scala.Serializable)x$1 -> userType.fieldType(BoxesRunTime.unboxToInt(x$1)));
            } else if (abstractType instanceof TupleType) {
                TupleType tupleType = (TupleType)abstractType;
                option = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tupleType.size()).find((JFunction1$mcZI$sp & scala.Serializable)x$2 -> {
                    String string = ((Object)BoxesRunTime.boxToInteger(x$2)).toString();
                    String string2 = child;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }).map((Function1<Object, AbstractType> & Serializable & scala.Serializable)x$1 -> tupleType.type(BoxesRunTime.unboxToInt(x$1)));
            } else {
                option = None$.MODULE$;
            }
        }
        return option;
    }

    public boolean supports(AbstractType<?> candidateType, Seq<Class<?>> supportedTypes, List<Class<?>> excludedTypes, boolean supportsCollections) {
        boolean bl;
        block7: {
            block8: {
                while (true) {
                    AbstractType abstractType;
                    if ((abstractType = candidateType) instanceof ReversedType) {
                        ReversedType reversedType = (ReversedType)abstractType;
                        candidateType = reversedType.baseType;
                        continue;
                    }
                    if (abstractType instanceof SetType) {
                        SetType setType = (SetType)abstractType;
                        if (supportsCollections) {
                            candidateType = setType.getElementsType();
                            continue;
                        }
                        bl = false;
                        break block7;
                    }
                    if (abstractType instanceof ListType) {
                        ListType listType = (ListType)abstractType;
                        if (supportsCollections) {
                            candidateType = listType.getElementsType();
                            continue;
                        }
                        bl = false;
                        break block7;
                    }
                    if (!(abstractType instanceof MapType)) break block8;
                    MapType mapType = (MapType)abstractType;
                    if (!supportsCollections) break;
                    candidateType = mapType.getValuesType();
                }
                bl = false;
                break block7;
            }
            Class<?> clazz = this.nativeType(candidateType);
            if (excludedTypes.contains(clazz)) {
                return false;
            }
            bl = supportedTypes.exists((Function1<Class, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.isAssignableFrom(clazz)));
        }
        return bl;
    }

    public Class<?> nativeType(AbstractType<?> validator) {
        Class clazz;
        AbstractType<?> abstractType = validator;
        boolean bl = abstractType instanceof UTF8Type ? true : abstractType instanceof AsciiType;
        if (bl) {
            clazz = String.class;
        } else {
            boolean bl2 = abstractType instanceof SimpleDateType ? true : abstractType instanceof TimestampType;
            if (bl2) {
                clazz = Date.class;
            } else {
                boolean bl3 = abstractType instanceof UUIDType ? true : (abstractType instanceof LexicalUUIDType ? true : abstractType instanceof TimeUUIDType);
                if (bl3) {
                    clazz = UUID.class;
                } else if (abstractType instanceof ShortType) {
                    clazz = Short.class;
                } else if (abstractType instanceof ByteType) {
                    clazz = Byte.class;
                } else if (abstractType instanceof Int32Type) {
                    clazz = Integer.class;
                } else if (abstractType instanceof LongType) {
                    clazz = Long.class;
                } else if (abstractType instanceof IntegerType) {
                    clazz = BigInteger.class;
                } else if (abstractType instanceof FloatType) {
                    clazz = Float.class;
                } else if (abstractType instanceof DoubleType) {
                    clazz = Double.class;
                } else if (abstractType instanceof DecimalType) {
                    clazz = BigDecimal.class;
                } else if (abstractType instanceof BooleanType) {
                    clazz = Boolean.class;
                } else if (abstractType instanceof BytesType) {
                    clazz = ByteBuffer.class;
                } else if (abstractType instanceof InetAddressType) {
                    clazz = InetAddress.class;
                } else {
                    throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported Cassandra data type: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{validator.getClass()})));
                }
            }
        }
        return clazz;
    }

    public static final /* synthetic */ void $anonfun$validate$1(SchemaValidator$ $this, CFMetaData metadata$1, Mapper mapper) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mapper.mappedColumns).asScala()).foreach((Function1<String, Object> & Serializable & scala.Serializable)column -> {
            $this.validate(metadata$1, column, mapper.field, ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(mapper.supportedTypes).asScala()).toList(), ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(mapper.excludedTypes).asScala()).toList(), Predef$.MODULE$.Boolean2boolean(mapper.supportsCollections));
            return BoxedUnit.UNIT;
        });
    }

    private final void checkSupported$1(AbstractType t, String mapper, boolean supportsCollections, String field$1, List supportedTypes$1, List excludedTypes$1) {
        if (!this.supports(t, supportedTypes$1, excludedTypes$1, supportsCollections)) {
            throw new IndexException("Type '{}' in column '{}' is not supported by mapper '{}'", t, (Object)mapper, (Object)field$1);
        }
    }

    private SchemaValidator$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger((String)this.getClass().getName()));
    }
}

