/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.util;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.util.TaskQueue;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0005\u001b\tqA+Y:l#V,W/Z!ts:\u001c'BA\u0002\u0005\u0003\u0011)H/\u001b7\u000b\u0005\u00151\u0011A\u00027vG\u0016tWM\u0003\u0002\b\u0011\u0005I1-Y:tC:$'/\u0019\u0006\u0003\u0013)\tqa\u001d;sCRLwNC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\n)\u0006\u001c8.U;fk\u0016D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001c\bCA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"aA%oi\"A1\u0005\u0001B\u0001B\u0003%A$\u0001\u0006rk\u0016,Xm]*ju\u0016DQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtDcA\u0014)SA\u0011q\u0003\u0001\u0005\u00067\u0011\u0002\r\u0001\b\u0005\u0006G\u0011\u0002\r\u0001\b\u0005\bW\u0001\u0011\r\u0011\"\u0003-\u0003\u0011awnY6\u0016\u00035\u0002\"A\f\u001b\u000e\u0003=R!\u0001M\u0019\u0002\u000b1|7m[:\u000b\u0005I\u001a\u0014AC2p]\u000e,(O]3oi*\u00111AE\u0005\u0003k=\u0012aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m\u001b\u0005\u0007o\u0001\u0001\u000b\u0011B\u0017\u0002\u000b1|7m\u001b\u0011\t\u000fe\u0002!\u0019!C\u0005u\u0005)\u0001o\\8mgV\t1\bE\u0002=\u0003\u000ek\u0011!\u0010\u0006\u0003}}\n\u0011\"[7nkR\f'\r\\3\u000b\u0005\u0001s\u0012AC2pY2,7\r^5p]&\u0011!)\u0010\u0002\u000b\u0013:$W\r_3e'\u0016\f\bC\u0001#F\u001b\u0005\t\u0014B\u0001$2\u0005I!\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\t\r!\u0003\u0001\u0015!\u0003<\u0003\u0019\u0001xn\u001c7tA!)!\n\u0001C!\u0017\u0006\u00112/\u001e2nSR\f5/\u001f8dQJ|gn\\;t+\taE\fF\u0002N!V\u0003\"!\b(\n\u0005=s\"\u0001B+oSRDQ!U%A\u0002I\u000b!!\u001b3\u0011\u0005u\u0019\u0016B\u0001+\u001f\u0005\u0019\te.\u001f*fM\")a+\u0013a\u0001/\u0006!A/Y:l!\ri\u0002LW\u0005\u00033z\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0005mcF\u0002\u0001\u0003\u0006;&\u0013\rA\u0018\u0002\u0002\u0003F\u0011qL\u0019\t\u0003;\u0001L!!\u0019\u0010\u0003\u000f9{G\u000f[5oOB\u0011QdY\u0005\u0003Iz\u00111!\u00118z\u0011\u00151\u0007\u0001\"\u0011h\u0003E\u0019XOY7jiNKhn\u00195s_:|Wo]\u000b\u0003Q*$\"![6\u0011\u0005mSG!B/f\u0005\u0004q\u0006\"\u0002,f\u0001\u0004a\u0007cA\u000fYS\")a\u000e\u0001C!_\u0006)1\r\\8tKR\tQ\n")
public class TaskQueueAsync
implements TaskQueue {
    private final int numThreads;
    private final int queuesSize;
    private final ReentrantReadWriteLock lock;
    private final IndexedSeq<ThreadPoolExecutor> pools;
    private final Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private IndexedSeq<ThreadPoolExecutor> pools() {
        return this.pools;
    }

    @Override
    public <A> void submitAsynchronous(Object id, Function0<A> task) {
        this.lock().readLock().lock();
        try {
            try {
                ((AbstractExecutorService)this.pools().apply(Math.abs(id.hashCode() % this.numThreads))).submit(() -> task.apply());
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Task queue asynchronous submission failed", (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IndexException(e);
            }
        }
        finally {
            this.lock().readLock().unlock();
        }
    }

    @Override
    public <A> A submitSynchronous(Function0<A> task) {
        A a;
        this.lock().writeLock().lock();
        try {
            try {
                ((TraversableLike)this.pools().map((Function1<ThreadPoolExecutor, Future> & Serializable & scala.Serializable)x$2 -> x$2.submit(() -> None$.MODULE$), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1<Future, None$> & Serializable & scala.Serializable)x$3 -> (None$)x$3.get(), IndexedSeq$.MODULE$.canBuildFrom());
                a = task.apply();
            }
            catch (InterruptedException e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Task queue await interrupted", (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IndexException(e);
            }
            catch (ExecutionException e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Task queue await failed", (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IndexException(e);
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Task queue synchronous submission failed", (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IndexException(e);
            }
        }
        finally {
            this.lock().writeLock().unlock();
        }
        return a;
    }

    @Override
    public void close() {
        this.lock().writeLock().lock();
        try {
            this.pools().foreach((Function1<ThreadPoolExecutor, Object> & Serializable & scala.Serializable)x$4 -> {
                x$4.shutdown();
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.lock().writeLock().unlock();
        }
    }

    public static final /* synthetic */ ArrayBlockingQueue $anonfun$pools$1(TaskQueueAsync $this, int x$1) {
        return new ArrayBlockingQueue($this.queuesSize, true);
    }

    public TaskQueueAsync(int numThreads, int queuesSize) {
        this.numThreads = numThreads;
        this.queuesSize = queuesSize;
        StrictLogging.$init$(this);
        this.lock = new ReentrantReadWriteLock(true);
        this.pools = ((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numThreads).map((Function1<Object, ArrayBlockingQueue> & Serializable & scala.Serializable)x$1 -> TaskQueueAsync.$anonfun$pools$1(this, BoxesRunTime.unboxToInt(x$1)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1<ArrayBlockingQueue, ThreadPoolExecutor> & Serializable & scala.Serializable)q -> new ThreadPoolExecutor(1, 1, 1L, TimeUnit.DAYS, (BlockingQueue<Runnable>)q, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("lucene-indexer-%d").build(), (task, executor) -> {
            block0: {
                if (executor.isShutdown()) break block0;
                executor.getQueue().put(task);
            }
        }), IndexedSeq$.MODULE$.canBuildFrom());
    }
}

