/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.stratio.cassandra.lucene.Index;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.IsBootstrappingException;
import org.apache.cassandra.exceptions.ReadFailureException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.metrics.ClientRequestMetrics;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.AbstractIterator;

public class LuceneStorageProxy {
    private static final ClientRequestMetrics readMetrics = new ClientRequestMetrics("Read");
    private static Method systemKeyspaceQuery;
    private static Method fetchRows;

    private static boolean systemKeyspaceQuery(List<? extends ReadCommand> cmds) throws ReflectiveOperationException {
        return (Boolean)systemKeyspaceQuery.invoke(null, cmds);
    }

    private static PartitionIterator fetchRows(List<SinglePartitionReadCommand> commands, ConsistencyLevel cl, long queryStartNanoTime) throws ReflectiveOperationException {
        return (PartitionIterator)fetchRows.invoke(null, commands, cl, queryStartNanoTime);
    }

    public static PartitionIterator read(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyLevel, long queryStartNanoTime) throws UnavailableException, IsBootstrappingException, ReadFailureException, ReadTimeoutException, InvalidRequestException, ReflectiveOperationException {
        if (StorageService.instance.isBootstrapMode() && !LuceneStorageProxy.systemKeyspaceQuery(group.commands)) {
            LuceneStorageProxy.readMetrics.unavailables.mark();
            throw new IsBootstrappingException();
        }
        return LuceneStorageProxy.readRegular(group, consistencyLevel, queryStartNanoTime);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PartitionIterator readRegular(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyLevel, long queryStartNanoTime) throws UnavailableException, ReadFailureException, ReadTimeoutException, ReflectiveOperationException {
        PartitionIterator partitionIterator;
        long start = System.nanoTime();
        try {
            PartitionIterator result2 = LuceneStorageProxy.fetchRows(group.commands, consistencyLevel, queryStartNanoTime);
            if (group.commands.size() > 1) {
                ReadCommand command = (ReadCommand)group.commands.get(0);
                CFMetaData metadata = group.metadata();
                ColumnFamilyStore cfs = Keyspace.open((String)metadata.ksName).getColumnFamilyStore(metadata.cfName);
                Index index = (Index)command.getIndex(cfs);
                result2 = index.postProcessorFor(group).apply(result2, group);
                result2 = group.limits().filter(result2, group.nowInSec());
            }
            partitionIterator = result2;
        }
        catch (UnavailableException e) {
            try {
                LuceneStorageProxy.readMetrics.unavailables.mark();
                throw e;
                catch (ReadTimeoutException e2) {
                    LuceneStorageProxy.readMetrics.timeouts.mark();
                    throw e2;
                }
                catch (ReadFailureException e3) {
                    LuceneStorageProxy.readMetrics.failures.mark();
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                long latency = System.nanoTime() - start;
                readMetrics.addNano(latency);
                Iterator iterator = group.commands.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw throwable;
                    }
                    ReadCommand command = (ReadCommand)iterator.next();
                    Keyspace.openAndGetStore((CFMetaData)command.metadata()).metric.coordinatorReadLatency.update(latency, TimeUnit.NANOSECONDS);
                }
            }
        }
        long latency = System.nanoTime() - start;
        readMetrics.addNano(latency);
        Iterator iterator = group.commands.iterator();
        while (iterator.hasNext()) {
            ReadCommand command = (ReadCommand)iterator.next();
            Keyspace.openAndGetStore((CFMetaData)command.metadata()).metric.coordinatorReadLatency.update(latency, TimeUnit.NANOSECONDS);
        }
        return partitionIterator;
    }

    public static RangeMerger rangeMerger(PartitionRangeReadCommand command, ConsistencyLevel consistency) {
        Keyspace keyspace = Keyspace.open((String)command.metadata().ksName);
        RangeIterator rangeIterator = new RangeIterator(command, keyspace, consistency);
        return new RangeMerger((Iterator)((Object)rangeIterator), keyspace, consistency);
    }

    public static <T extends RingPosition<T>> List<AbstractBounds<T>> getRestrictedRanges(AbstractBounds<T> queryRange) {
        return StorageProxy.getRestrictedRanges(queryRange);
    }

    private static List<InetAddress> intersection(List<InetAddress> l1, List<InetAddress> l2) {
        ArrayList<InetAddress> inter = new ArrayList<InetAddress>(l1);
        inter.retainAll(l2);
        return inter;
    }

    static {
        try {
            systemKeyspaceQuery = StorageProxy.class.getDeclaredMethod("systemKeyspaceQuery", List.class);
            systemKeyspaceQuery.setAccessible(true);
            fetchRows = StorageProxy.class.getDeclaredMethod("fetchRows", List.class, ConsistencyLevel.class, Long.TYPE);
            fetchRows.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class RangeMerger
    extends AbstractIterator<RangeForQuery> {
        private final Keyspace keyspace;
        private final ConsistencyLevel consistency;
        private final PeekingIterator<RangeForQuery> ranges;

        private RangeMerger(Iterator<RangeForQuery> iterator, Keyspace keyspace, ConsistencyLevel consistency) {
            this.keyspace = keyspace;
            this.consistency = consistency;
            this.ranges = Iterators.peekingIterator(iterator);
        }

        protected RangeForQuery computeNext() {
            if (!this.ranges.hasNext()) {
                return (RangeForQuery)this.endOfData();
            }
            RangeForQuery current = (RangeForQuery)this.ranges.next();
            while (this.ranges.hasNext() && !((PartitionPosition)current.range.right).isMinimum()) {
                RangeForQuery next = (RangeForQuery)this.ranges.peek();
                List merged = LuceneStorageProxy.intersection(current.liveEndpoints, next.liveEndpoints);
                if (!this.consistency.isSufficientLiveNodes(this.keyspace, (Iterable)merged)) break;
                List filteredMerged = this.consistency.filterForQuery(this.keyspace, merged);
                if (!DatabaseDescriptor.getEndpointSnitch().isWorthMergingForRangeQuery(filteredMerged, current.filteredEndpoints, next.filteredEndpoints)) break;
                current = new RangeForQuery((AbstractBounds<PartitionPosition>)current.range.withNewRight(next.range.right), merged, filteredMerged);
                this.ranges.next();
            }
            return current;
        }
    }

    public static class RangeForQuery {
        public final AbstractBounds<PartitionPosition> range;
        public final List<InetAddress> liveEndpoints;
        public final List<InetAddress> filteredEndpoints;

        public RangeForQuery(AbstractBounds<PartitionPosition> range, List<InetAddress> liveEndpoints, List<InetAddress> filteredEndpoints) {
            this.range = range;
            this.liveEndpoints = liveEndpoints;
            this.filteredEndpoints = filteredEndpoints;
        }
    }

    public static class RangeIterator
    extends AbstractIterator<RangeForQuery> {
        private final Keyspace keyspace;
        private final ConsistencyLevel consistency;
        private final Iterator<? extends AbstractBounds<PartitionPosition>> ranges;
        private final int rangeCount;

        public RangeIterator(PartitionRangeReadCommand command, Keyspace keyspace, ConsistencyLevel consistency) {
            this.keyspace = keyspace;
            this.consistency = consistency;
            List l = keyspace.getReplicationStrategy() instanceof LocalStrategy ? command.dataRange().keyRange().unwrap() : LuceneStorageProxy.getRestrictedRanges(command.dataRange().keyRange());
            this.ranges = l.iterator();
            this.rangeCount = l.size();
        }

        public int rangeCount() {
            return this.rangeCount;
        }

        protected RangeForQuery computeNext() {
            if (!this.ranges.hasNext()) {
                return (RangeForQuery)this.endOfData();
            }
            AbstractBounds<PartitionPosition> range = this.ranges.next();
            List liveEndpoints = StorageProxy.getLiveSortedEndpoints((Keyspace)this.keyspace, (RingPosition)range.right);
            return new RangeForQuery(range, liveEndpoints, this.consistency.filterForQuery(this.keyspace, liveEndpoints));
        }
    }
}

