/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.bkdtree3d;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.bkdtree3d.BKD3DTreeWriter;
import org.apache.lucene.bkdtree3d.Geo3DDocValuesFormat;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

@Deprecated
class Geo3DDocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    final DocValuesConsumer delegate;
    final int maxPointsInLeafNode;
    final int maxPointsSortInHeap;
    final IndexOutput out;
    final Map<Integer, Long> fieldIndexFPs = new HashMap<Integer, Long>();
    final SegmentWriteState state;

    public Geo3DDocValuesConsumer(PlanetModel planetModel, DocValuesConsumer delegate, SegmentWriteState state, int maxPointsInLeafNode, int maxPointsSortInHeap) throws IOException {
        BKD3DTreeWriter.verifyParams(maxPointsInLeafNode, maxPointsSortInHeap);
        this.delegate = delegate;
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.maxPointsSortInHeap = maxPointsSortInHeap;
        this.state = state;
        String datFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "g3dd");
        this.out = state.directory.createOutput(datFileName, state.context);
        CodecUtil.writeIndexHeader(this.out, "Geo3DData", 0, state.segmentInfo.getId(), state.segmentSuffix);
        this.out.writeLong(Double.doubleToLongBits(planetModel.getMaximumMagnitude()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block12: {
            IndexOutput metaOut;
            block10: {
                boolean success;
                block11: {
                    block9: {
                        success = false;
                        try {
                            CodecUtil.writeFooter(this.out);
                            success = true;
                            if (!success) break block9;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                IOUtils.close(this.delegate, this.out);
                            } else {
                                IOUtils.closeWhileHandlingException(this.delegate, this.out);
                            }
                            throw throwable;
                        }
                        IOUtils.close(this.delegate, this.out);
                        break block11;
                    }
                    IOUtils.closeWhileHandlingException(this.delegate, this.out);
                }
                String metaFileName = IndexFileNames.segmentFileName(this.state.segmentInfo.name, this.state.segmentSuffix, "g3dm");
                metaOut = this.state.directory.createOutput(metaFileName, this.state.context);
                success = false;
                try {
                    CodecUtil.writeIndexHeader(metaOut, "Geo3DMeta", 0, this.state.segmentInfo.getId(), this.state.segmentSuffix);
                    metaOut.writeVInt(this.fieldIndexFPs.size());
                    for (Map.Entry<Integer, Long> ent : this.fieldIndexFPs.entrySet()) {
                        metaOut.writeVInt(ent.getKey());
                        metaOut.writeVLong(ent.getValue());
                    }
                    CodecUtil.writeFooter(metaOut);
                    success = true;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(metaOut);
                    } else {
                        IOUtils.closeWhileHandlingException(metaOut);
                    }
                    throw throwable;
                }
                IOUtils.close(metaOut);
                break block12;
            }
            IOUtils.closeWhileHandlingException(metaOut);
        }
    }

    @Override
    public void addSortedNumericField(FieldInfo field2, Iterable<Number> docToValueCount, Iterable<Number> values) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNumericField(FieldInfo field2, Iterable<Number> values) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBinaryField(FieldInfo field2, Iterable<BytesRef> values) throws IOException {
        this.delegate.addBinaryField(field2, values);
        BKD3DTreeWriter writer = new BKD3DTreeWriter(this.maxPointsInLeafNode, this.maxPointsSortInHeap);
        Iterator<BytesRef> valuesIt = values.iterator();
        for (int docID = 0; docID < this.state.segmentInfo.maxDoc(); ++docID) {
            assert (valuesIt.hasNext());
            BytesRef value = valuesIt.next();
            if (value == null) continue;
            assert (value.length == 12);
            int x = Geo3DDocValuesFormat.readInt(value.bytes, value.offset);
            int y = Geo3DDocValuesFormat.readInt(value.bytes, value.offset + 4);
            int z = Geo3DDocValuesFormat.readInt(value.bytes, value.offset + 8);
            writer.add(x, y, z, docID);
        }
        long indexStartFP = writer.finish(this.out);
        this.fieldIndexFPs.put(field2.number, indexStartFP);
    }

    @Override
    public void addSortedField(FieldInfo field2, Iterable<BytesRef> values, Iterable<Number> docToOrd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSortedSetField(FieldInfo field2, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) {
        throw new UnsupportedOperationException();
    }
}

