/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.Bounds;
import org.apache.lucene.geo3d.DistanceStyle;
import org.apache.lucene.geo3d.GeoBBox;
import org.apache.lucene.geo3d.GeoBBoxFactory;
import org.apache.lucene.geo3d.GeoBaseBBox;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.GeoShape;
import org.apache.lucene.geo3d.Membership;
import org.apache.lucene.geo3d.Plane;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.SidedPlane;
import org.apache.lucene.geo3d.Vector;

public class GeoDegenerateLongitudeSlice
extends GeoBaseBBox {
    protected final double longitude;
    protected final SidedPlane boundingPlane;
    protected final Plane plane;
    protected final GeoPoint interiorPoint;
    protected final GeoPoint[] edgePoints;
    protected final GeoPoint[] planePoints;

    public GeoDegenerateLongitudeSlice(PlanetModel planetModel, double longitude) {
        super(planetModel);
        if (longitude < -Math.PI || longitude > Math.PI) {
            throw new IllegalArgumentException("Longitude out of range");
        }
        this.longitude = longitude;
        double sinLongitude = Math.sin(longitude);
        double cosLongitude = Math.cos(longitude);
        this.plane = new Plane(cosLongitude, sinLongitude);
        this.interiorPoint = new GeoPoint(planetModel, 0.0, sinLongitude, 1.0, cosLongitude);
        this.boundingPlane = new SidedPlane((Vector)this.interiorPoint, -sinLongitude, cosLongitude);
        this.edgePoints = new GeoPoint[]{this.interiorPoint};
        this.planePoints = new GeoPoint[]{planetModel.NORTH_POLE, planetModel.SOUTH_POLE};
    }

    @Override
    public GeoBBox expand(double angle) {
        double newLeftLon = this.longitude - angle;
        double newRightLon = this.longitude + angle;
        double currentLonSpan = 2.0 * angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, 1.5707963267948966, -1.5707963267948966, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.plane.evaluateIsZero(x, y, z) && this.boundingPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        return 1.5707963267948966;
    }

    @Override
    public GeoPoint getCenter() {
        return this.interiorPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.plane, notablePoints, this.planePoints, bounds, this.boundingPlane);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.addVerticalPlane(this.planetModel, this.longitude, this.plane, this.boundingPlane).addPoint(this.planetModel.NORTH_POLE).addPoint(this.planetModel.SOUTH_POLE);
    }

    @Override
    public int getRelationship(GeoShape path) {
        if (path.intersects(this.plane, this.planePoints, this.boundingPlane)) {
            return 2;
        }
        if (path.isWithin(this.interiorPoint)) {
            return 0;
        }
        return 3;
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double distance = distanceStyle.computeDistance(this.planetModel, this.plane, x, y, z, this.boundingPlane);
        double northDistance = distanceStyle.computeDistance(this.planetModel.NORTH_POLE, x, y, z);
        double southDistance = distanceStyle.computeDistance(this.planetModel.SOUTH_POLE, x, y, z);
        return Math.min(distance, Math.min(northDistance, southDistance));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoDegenerateLongitudeSlice)) {
            return false;
        }
        GeoDegenerateLongitudeSlice other = (GeoDegenerateLongitudeSlice)o;
        return super.equals(other) && other.longitude == this.longitude;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        long temp = Double.doubleToLongBits(this.longitude);
        result2 = result2 * 31 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    public String toString() {
        return "GeoDegenerateLongitudeSlice: {planetmodel=" + this.planetModel + ", longitude=" + this.longitude + "(" + this.longitude * 180.0 / Math.PI + ")}";
    }
}

