/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.BaseXYZSolid;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.GeoShape;
import org.apache.lucene.geo3d.Plane;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.SidedPlane;

public class StandardXYZSolid
extends BaseXYZSolid {
    protected final boolean isWholeWorld;
    protected final SidedPlane minXPlane;
    protected final SidedPlane maxXPlane;
    protected final SidedPlane minYPlane;
    protected final SidedPlane maxYPlane;
    protected final SidedPlane minZPlane;
    protected final SidedPlane maxZPlane;
    protected final GeoPoint[] edgePoints;
    protected final GeoPoint[] notableMinXPoints;
    protected final GeoPoint[] notableMaxXPoints;
    protected final GeoPoint[] notableMinYPoints;
    protected final GeoPoint[] notableMaxYPoints;
    protected final GeoPoint[] notableMinZPoints;
    protected final GeoPoint[] notableMaxZPoints;

    public StandardXYZSolid(PlanetModel planetModel, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        super(planetModel);
        if (maxX - minX < 1.0E-12) {
            throw new IllegalArgumentException("X values in wrong order or identical");
        }
        if (maxY - minY < 1.0E-12) {
            throw new IllegalArgumentException("Y values in wrong order or identical");
        }
        if (maxZ - minZ < 1.0E-12) {
            throw new IllegalArgumentException("Z values in wrong order or identical");
        }
        double worldMinX = planetModel.getMinimumXValue();
        double worldMaxX = planetModel.getMaximumXValue();
        double worldMinY = planetModel.getMinimumYValue();
        double worldMaxY = planetModel.getMaximumYValue();
        double worldMinZ = planetModel.getMinimumZValue();
        double worldMaxZ = planetModel.getMaximumZValue();
        boolean bl = this.isWholeWorld = minX - worldMinX < -1.0E-12 && maxX - worldMaxX > 1.0E-12 && minY - worldMinY < -1.0E-12 && maxY - worldMaxY > 1.0E-12 && minZ - worldMinZ < -1.0E-12 && maxZ - worldMaxZ > 1.0E-12;
        if (this.isWholeWorld) {
            this.minXPlane = null;
            this.maxXPlane = null;
            this.minYPlane = null;
            this.maxYPlane = null;
            this.minZPlane = null;
            this.maxZPlane = null;
            this.notableMinXPoints = null;
            this.notableMaxXPoints = null;
            this.notableMinYPoints = null;
            this.notableMaxYPoints = null;
            this.notableMinZPoints = null;
            this.notableMaxZPoints = null;
            this.edgePoints = null;
        } else {
            GeoPoint intPoint;
            GeoPoint intPoint2;
            GeoPoint intPoint3;
            GeoPoint intPoint4;
            GeoPoint intPoint5;
            GeoPoint intPoint6;
            this.minXPlane = new SidedPlane(maxX, 0.0, 0.0, xUnitVector, -minX);
            this.maxXPlane = new SidedPlane(minX, 0.0, 0.0, xUnitVector, -maxX);
            this.minYPlane = new SidedPlane(0.0, maxY, 0.0, yUnitVector, -minY);
            this.maxYPlane = new SidedPlane(0.0, minY, 0.0, yUnitVector, -maxY);
            this.minZPlane = new SidedPlane(0.0, 0.0, maxZ, zUnitVector, -minZ);
            this.maxZPlane = new SidedPlane(0.0, 0.0, minZ, zUnitVector, -maxZ);
            GeoPoint[] minXminY = this.minXPlane.findIntersections(planetModel, (Plane)this.minYPlane, this.maxXPlane, this.maxYPlane, this.minZPlane, this.maxZPlane);
            GeoPoint[] minXmaxY = this.minXPlane.findIntersections(planetModel, (Plane)this.maxYPlane, this.maxXPlane, this.minYPlane, this.minZPlane, this.maxZPlane);
            GeoPoint[] minXminZ = this.minXPlane.findIntersections(planetModel, (Plane)this.minZPlane, this.maxXPlane, this.maxZPlane, this.minYPlane, this.maxYPlane);
            GeoPoint[] minXmaxZ = this.minXPlane.findIntersections(planetModel, (Plane)this.maxZPlane, this.maxXPlane, this.minZPlane, this.minYPlane, this.maxYPlane);
            GeoPoint[] maxXminY = this.maxXPlane.findIntersections(planetModel, (Plane)this.minYPlane, this.minXPlane, this.maxYPlane, this.minZPlane, this.maxZPlane);
            GeoPoint[] maxXmaxY = this.maxXPlane.findIntersections(planetModel, (Plane)this.maxYPlane, this.minXPlane, this.minYPlane, this.minZPlane, this.maxZPlane);
            GeoPoint[] maxXminZ = this.maxXPlane.findIntersections(planetModel, (Plane)this.minZPlane, this.minXPlane, this.maxZPlane, this.minYPlane, this.maxYPlane);
            GeoPoint[] maxXmaxZ = this.maxXPlane.findIntersections(planetModel, (Plane)this.maxZPlane, this.minXPlane, this.minZPlane, this.minYPlane, this.maxYPlane);
            GeoPoint[] minYminZ = this.minYPlane.findIntersections(planetModel, (Plane)this.minZPlane, this.maxYPlane, this.maxZPlane, this.minXPlane, this.maxXPlane);
            GeoPoint[] minYmaxZ = this.minYPlane.findIntersections(planetModel, (Plane)this.maxZPlane, this.maxYPlane, this.minZPlane, this.minXPlane, this.maxXPlane);
            GeoPoint[] maxYminZ = this.maxYPlane.findIntersections(planetModel, (Plane)this.minZPlane, this.minYPlane, this.maxZPlane, this.minXPlane, this.maxXPlane);
            GeoPoint[] maxYmaxZ = this.maxYPlane.findIntersections(planetModel, (Plane)this.maxZPlane, this.minYPlane, this.minZPlane, this.minXPlane, this.maxXPlane);
            this.notableMinXPoints = StandardXYZSolid.glueTogether(minXminY, minXmaxY, minXminZ, minXmaxZ);
            this.notableMaxXPoints = StandardXYZSolid.glueTogether(maxXminY, maxXmaxY, maxXminZ, maxXmaxZ);
            this.notableMinYPoints = StandardXYZSolid.glueTogether(minXminY, maxXminY, minYminZ, minYmaxZ);
            this.notableMaxYPoints = StandardXYZSolid.glueTogether(minXmaxY, maxXmaxY, maxYminZ, maxYmaxZ);
            this.notableMinZPoints = StandardXYZSolid.glueTogether(minXminZ, maxXminZ, minYminZ, maxYminZ);
            this.notableMaxZPoints = StandardXYZSolid.glueTogether(minXmaxZ, maxXmaxZ, minYmaxZ, maxYmaxZ);
            boolean minXminYminZ = planetModel.pointOutside(minX, minY, minZ);
            boolean minXminYmaxZ = planetModel.pointOutside(minX, minY, maxZ);
            boolean minXmaxYminZ = planetModel.pointOutside(minX, maxY, minZ);
            boolean minXmaxYmaxZ = planetModel.pointOutside(minX, maxY, maxZ);
            boolean maxXminYminZ = planetModel.pointOutside(maxX, minY, minZ);
            boolean maxXminYmaxZ = planetModel.pointOutside(maxX, minY, maxZ);
            boolean maxXmaxYminZ = planetModel.pointOutside(maxX, maxY, minZ);
            boolean maxXmaxYmaxZ = planetModel.pointOutside(maxX, maxY, maxZ);
            GeoPoint[] minXEdges = minX - worldMinX >= -1.0E-12 && minX - worldMaxX <= 1.0E-12 && minY < 0.0 && maxY > 0.0 && minZ < 0.0 && maxZ > 0.0 && minXminYminZ && minXminYmaxZ && minXmaxYminZ && minXmaxYmaxZ ? ((intPoint6 = this.minXPlane.getSampleIntersectionPoint(planetModel, xVerticalPlane)) != null ? new GeoPoint[]{intPoint6} : EMPTY_POINTS) : EMPTY_POINTS;
            GeoPoint[] maxXEdges = maxX - worldMinX >= -1.0E-12 && maxX - worldMaxX <= 1.0E-12 && minY < 0.0 && maxY > 0.0 && minZ < 0.0 && maxZ > 0.0 && maxXminYminZ && maxXminYmaxZ && maxXmaxYminZ && maxXmaxYmaxZ ? ((intPoint5 = this.maxXPlane.getSampleIntersectionPoint(planetModel, xVerticalPlane)) != null ? new GeoPoint[]{intPoint5} : EMPTY_POINTS) : EMPTY_POINTS;
            GeoPoint[] minYEdges = minY - worldMinY >= -1.0E-12 && minY - worldMaxY <= 1.0E-12 && minX < 0.0 && maxX > 0.0 && minZ < 0.0 && maxZ > 0.0 && minXminYminZ && minXminYmaxZ && maxXminYminZ && maxXminYmaxZ ? ((intPoint4 = this.minYPlane.getSampleIntersectionPoint(planetModel, yVerticalPlane)) != null ? new GeoPoint[]{intPoint4} : EMPTY_POINTS) : EMPTY_POINTS;
            GeoPoint[] maxYEdges = maxY - worldMinY >= -1.0E-12 && maxY - worldMaxY <= 1.0E-12 && minX < 0.0 && maxX > 0.0 && minZ < 0.0 && maxZ > 0.0 && minXmaxYminZ && minXmaxYmaxZ && maxXmaxYminZ && maxXmaxYmaxZ ? ((intPoint3 = this.maxYPlane.getSampleIntersectionPoint(planetModel, yVerticalPlane)) != null ? new GeoPoint[]{intPoint3} : EMPTY_POINTS) : EMPTY_POINTS;
            GeoPoint[] minZEdges = minZ - worldMinZ >= -1.0E-12 && minZ - worldMaxZ <= 1.0E-12 && minX < 0.0 && maxX > 0.0 && minY < 0.0 && maxY > 0.0 && minXminYminZ && minXmaxYminZ && maxXminYminZ && maxXmaxYminZ ? ((intPoint2 = this.minZPlane.getSampleIntersectionPoint(planetModel, xVerticalPlane)) != null ? new GeoPoint[]{intPoint2} : EMPTY_POINTS) : EMPTY_POINTS;
            GeoPoint[] maxZEdges = maxZ - worldMinZ >= -1.0E-12 && maxZ - worldMaxZ <= 1.0E-12 && minX < 0.0 && maxX > 0.0 && minY < 0.0 && maxY > 0.0 && minXminYmaxZ && minXmaxYmaxZ && maxXminYmaxZ && maxXmaxYmaxZ ? ((intPoint = this.maxZPlane.getSampleIntersectionPoint(planetModel, xVerticalPlane)) != null ? new GeoPoint[]{intPoint} : EMPTY_POINTS) : EMPTY_POINTS;
            this.edgePoints = StandardXYZSolid.glueTogether(minXminY, minXmaxY, minXminZ, minXmaxZ, maxXminY, maxXmaxY, maxXminZ, maxXmaxZ, minYminZ, minYmaxZ, maxYminZ, maxYmaxZ, minXEdges, maxXEdges, minYEdges, maxYEdges, minZEdges, maxZEdges);
        }
    }

    @Override
    protected GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        if (this.isWholeWorld) {
            return true;
        }
        return this.minXPlane.isWithin(x, y, z) && this.maxXPlane.isWithin(x, y, z) && this.minYPlane.isWithin(x, y, z) && this.maxYPlane.isWithin(x, y, z) && this.minZPlane.isWithin(x, y, z) && this.maxZPlane.isWithin(x, y, z);
    }

    @Override
    public int getRelationship(GeoShape path) {
        if (this.isWholeWorld) {
            if (path.getEdgePoints().length > 0) {
                return 1;
            }
            return 2;
        }
        int insideRectangle = this.isShapeInsideArea(path);
        if (insideRectangle == 1) {
            return 2;
        }
        int insideShape = this.isAreaInsideShape(path);
        if (insideShape == 1) {
            return 2;
        }
        if (insideRectangle == 0 && insideShape == 0) {
            return 2;
        }
        if (path.intersects(this.minXPlane, this.notableMinXPoints, this.maxXPlane, this.minYPlane, this.maxYPlane, this.minZPlane, this.maxZPlane) || path.intersects(this.maxXPlane, this.notableMaxXPoints, this.minXPlane, this.minYPlane, this.maxYPlane, this.minZPlane, this.maxZPlane) || path.intersects(this.minYPlane, this.notableMinYPoints, this.maxYPlane, this.minXPlane, this.maxXPlane, this.minZPlane, this.maxZPlane) || path.intersects(this.maxYPlane, this.notableMaxYPoints, this.minYPlane, this.minXPlane, this.maxXPlane, this.minZPlane, this.maxZPlane) || path.intersects(this.minZPlane, this.notableMinZPoints, this.maxZPlane, this.minXPlane, this.maxXPlane, this.minYPlane, this.maxYPlane) || path.intersects(this.maxZPlane, this.notableMaxZPoints, this.minZPlane, this.minXPlane, this.maxXPlane, this.minYPlane, this.maxYPlane)) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape == 0) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof StandardXYZSolid)) {
            return false;
        }
        StandardXYZSolid other = (StandardXYZSolid)o;
        if (!super.equals(other) || other.isWholeWorld != this.isWholeWorld) {
            return false;
        }
        if (!this.isWholeWorld) {
            return other.minXPlane.equals(this.minXPlane) && other.maxXPlane.equals(this.maxXPlane) && other.minYPlane.equals(this.minYPlane) && other.maxYPlane.equals(this.maxYPlane) && other.minZPlane.equals(this.minZPlane) && other.maxZPlane.equals(this.maxZPlane);
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.isWholeWorld ? 1 : 0);
        if (!this.isWholeWorld) {
            result2 = 31 * result2 + this.minXPlane.hashCode();
            result2 = 31 * result2 + this.maxXPlane.hashCode();
            result2 = 31 * result2 + this.minYPlane.hashCode();
            result2 = 31 * result2 + this.maxYPlane.hashCode();
            result2 = 31 * result2 + this.minZPlane.hashCode();
            result2 = 31 * result2 + this.maxZPlane.hashCode();
        }
        return result2;
    }

    public String toString() {
        return "StandardXYZSolid: {planetmodel=" + this.planetModel + ", isWholeWorld=" + this.isWholeWorld + ", minXplane=" + this.minXPlane + ", maxXplane=" + this.maxXPlane + ", minYplane=" + this.minYPlane + ", maxYplane=" + this.maxYPlane + ", minZplane=" + this.minZPlane + ", maxZplane=" + this.maxZPlane + "}";
    }
}

