/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.BaseXYZSolid;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.GeoShape;
import org.apache.lucene.geo3d.Plane;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.SidedPlane;

public class dXYZSolid
extends BaseXYZSolid {
    protected final Plane xPlane;
    protected final SidedPlane minYPlane;
    protected final SidedPlane maxYPlane;
    protected final SidedPlane minZPlane;
    protected final SidedPlane maxZPlane;
    protected final GeoPoint[] edgePoints;
    protected final GeoPoint[] notableXPoints;

    public dXYZSolid(PlanetModel planetModel, double X, double minY, double maxY, double minZ, double maxZ) {
        super(planetModel);
        GeoPoint intPoint;
        if (maxY - minY < 1.0E-12) {
            throw new IllegalArgumentException("Y values in wrong order or identical");
        }
        if (maxZ - minZ < 1.0E-12) {
            throw new IllegalArgumentException("Z values in wrong order or identical");
        }
        double worldMinX = planetModel.getMinimumXValue();
        double worldMaxX = planetModel.getMaximumXValue();
        this.xPlane = new Plane(xUnitVector, -X);
        this.minYPlane = new SidedPlane(0.0, maxY, 0.0, yUnitVector, -minY);
        this.maxYPlane = new SidedPlane(0.0, minY, 0.0, yUnitVector, -maxY);
        this.minZPlane = new SidedPlane(0.0, 0.0, maxZ, zUnitVector, -minZ);
        this.maxZPlane = new SidedPlane(0.0, 0.0, minZ, zUnitVector, -maxZ);
        GeoPoint[] XminY = this.xPlane.findIntersections(planetModel, (Plane)this.minYPlane, this.maxYPlane, this.minZPlane, this.maxZPlane);
        GeoPoint[] XmaxY = this.xPlane.findIntersections(planetModel, (Plane)this.maxYPlane, this.minYPlane, this.minZPlane, this.maxZPlane);
        GeoPoint[] XminZ = this.xPlane.findIntersections(planetModel, (Plane)this.minZPlane, this.maxZPlane, this.minYPlane, this.maxYPlane);
        GeoPoint[] XmaxZ = this.xPlane.findIntersections(planetModel, (Plane)this.maxZPlane, this.minZPlane, this.minYPlane, this.maxYPlane);
        this.notableXPoints = dXYZSolid.glueTogether(XminY, XmaxY, XminZ, XmaxZ);
        boolean XminYminZ = planetModel.pointOutside(X, minY, minZ);
        boolean XminYmaxZ = planetModel.pointOutside(X, minY, maxZ);
        boolean XmaxYminZ = planetModel.pointOutside(X, maxY, minZ);
        boolean XmaxYmaxZ = planetModel.pointOutside(X, maxY, maxZ);
        GeoPoint[] xEdges = X - worldMinX >= -1.0E-12 && X - worldMaxX <= 1.0E-12 && minY < 0.0 && maxY > 0.0 && minZ < 0.0 && maxZ > 0.0 && XminYminZ && XminYmaxZ && XmaxYminZ && XmaxYmaxZ ? ((intPoint = this.xPlane.getSampleIntersectionPoint(planetModel, xVerticalPlane)) != null ? new GeoPoint[]{intPoint} : EMPTY_POINTS) : EMPTY_POINTS;
        this.edgePoints = dXYZSolid.glueTogether(XminY, XmaxY, XminZ, XmaxZ, xEdges);
    }

    @Override
    protected GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.xPlane.evaluateIsZero(x, y, z) && this.minYPlane.isWithin(x, y, z) && this.maxYPlane.isWithin(x, y, z) && this.minZPlane.isWithin(x, y, z) && this.maxZPlane.isWithin(x, y, z);
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideArea(path);
        if (insideRectangle == 1) {
            return 2;
        }
        int insideShape = this.isAreaInsideShape(path);
        if (insideShape == 1) {
            return 2;
        }
        if (insideRectangle == 0 && insideShape == 0) {
            return 2;
        }
        if (path.intersects(this.xPlane, this.notableXPoints, this.minYPlane, this.maxYPlane, this.minZPlane, this.maxZPlane)) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape == 0) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof dXYZSolid)) {
            return false;
        }
        dXYZSolid other = (dXYZSolid)o;
        if (!super.equals(other)) {
            return false;
        }
        return other.xPlane.equals(this.xPlane) && other.minYPlane.equals(this.minYPlane) && other.maxYPlane.equals(this.maxYPlane) && other.minZPlane.equals(this.minZPlane) && other.maxZPlane.equals(this.maxZPlane);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.xPlane.hashCode();
        result2 = 31 * result2 + this.minYPlane.hashCode();
        result2 = 31 * result2 + this.maxYPlane.hashCode();
        result2 = 31 * result2 + this.minZPlane.hashCode();
        result2 = 31 * result2 + this.maxZPlane.hashCode();
        return result2;
    }

    public String toString() {
        return "dXYZSolid: {planetmodel=" + this.planetModel + ", xplane=" + this.xPlane + ", minYplane=" + this.minYPlane + ", maxYplane=" + this.maxYPlane + ", minZplane=" + this.minZPlane + ", maxZplane=" + this.maxZPlane + "}";
    }
}

