/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.BaseXYZSolid;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.GeoShape;
import org.apache.lucene.geo3d.Plane;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.SidedPlane;

public class dXYdZSolid
extends BaseXYZSolid {
    protected final GeoPoint[] surfacePoints;

    public dXYdZSolid(PlanetModel planetModel, double X, double minY, double maxY, double Z) {
        super(planetModel);
        if (maxY - minY < 1.0E-12) {
            throw new IllegalArgumentException("Y values in wrong order or identical");
        }
        Plane xPlane = new Plane(xUnitVector, -X);
        Plane zPlane = new Plane(zUnitVector, -Z);
        SidedPlane minYPlane = new SidedPlane(0.0, maxY, 0.0, yUnitVector, -minY);
        SidedPlane maxYPlane = new SidedPlane(0.0, minY, 0.0, yUnitVector, -maxY);
        this.surfacePoints = xPlane.findIntersections(planetModel, zPlane, minYPlane, maxYPlane);
    }

    @Override
    protected GeoPoint[] getEdgePoints() {
        return this.surfacePoints;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (GeoPoint p : this.surfacePoints) {
            if (!p.isIdentical(x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRelationship(GeoShape path) {
        int insideRectangle = this.isShapeInsideArea(path);
        if (insideRectangle == 1) {
            return 2;
        }
        int insideShape = this.isAreaInsideShape(path);
        if (insideShape == 1) {
            return 2;
        }
        if (insideRectangle == 0 && insideShape == 0) {
            return 2;
        }
        if (insideRectangle == 0) {
            return 1;
        }
        if (insideShape == 0) {
            return 0;
        }
        return 3;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof dXYdZSolid)) {
            return false;
        }
        dXYdZSolid other = (dXYdZSolid)o;
        if (!super.equals(other) || this.surfacePoints.length != other.surfacePoints.length) {
            return false;
        }
        for (int i = 0; i < this.surfacePoints.length; ++i) {
            if (this.surfacePoints[i].equals(other.surfacePoints[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        for (GeoPoint p : this.surfacePoints) {
            result2 = 31 * result2 + p.hashCode();
        }
        return result2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (GeoPoint p : this.surfacePoints) {
            sb.append(" ").append(p).append(" ");
        }
        return "dXYdZSolid: {planetmodel=" + this.planetModel + ", " + sb.toString() + "}";
    }
}

