/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.IOUtils;

public abstract class CodecReader
extends LeafReader
implements Accountable {
    final CloseableThreadLocal<Map<String, Object>> docValuesLocal = new CloseableThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    final CloseableThreadLocal<Map<String, Bits>> docsWithFieldLocal = new CloseableThreadLocal<Map<String, Bits>>(){

        @Override
        protected Map<String, Bits> initialValue() {
            return new HashMap<String, Bits>();
        }
    };
    final CloseableThreadLocal<Map<String, NumericDocValues>> normsLocal = new CloseableThreadLocal<Map<String, NumericDocValues>>(){

        @Override
        protected Map<String, NumericDocValues> initialValue() {
            return new HashMap<String, NumericDocValues>();
        }
    };

    protected CodecReader() {
    }

    public abstract StoredFieldsReader getFieldsReader();

    public abstract TermVectorsReader getTermVectorsReader();

    public abstract NormsProducer getNormsReader();

    public abstract DocValuesProducer getDocValuesReader();

    public abstract FieldsProducer getPostingsReader();

    @Override
    public final void document(int docID, StoredFieldVisitor visitor) throws IOException {
        this.checkBounds(docID);
        this.getFieldsReader().visitDocument(docID, visitor);
    }

    @Override
    public final Fields getTermVectors(int docID) throws IOException {
        TermVectorsReader termVectorsReader = this.getTermVectorsReader();
        if (termVectorsReader == null) {
            return null;
        }
        this.checkBounds(docID);
        return termVectorsReader.get(docID);
    }

    private void checkBounds(int docID) {
        if (docID < 0 || docID >= this.maxDoc()) {
            throw new IndexOutOfBoundsException("docID must be >= 0 and < maxDoc=" + this.maxDoc() + " (got docID=" + docID + ")");
        }
    }

    @Override
    public final Fields fields() {
        return this.getPostingsReader();
    }

    private FieldInfo getDVField(String field2, DocValuesType type) {
        FieldInfo fi = this.getFieldInfos().fieldInfo(field2);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == DocValuesType.NONE) {
            return null;
        }
        if (fi.getDocValuesType() != type) {
            return null;
        }
        return fi;
    }

    @Override
    public final NumericDocValues getNumericDocValues(String field2) throws IOException {
        this.ensureOpen();
        Map<String, Object> dvFields = this.docValuesLocal.get();
        Object previous = dvFields.get(field2);
        if (previous != null && previous instanceof NumericDocValues) {
            return (NumericDocValues)previous;
        }
        FieldInfo fi = this.getDVField(field2, DocValuesType.NUMERIC);
        if (fi == null) {
            return null;
        }
        NumericDocValues dv = this.getDocValuesReader().getNumeric(fi);
        dvFields.put(field2, dv);
        return dv;
    }

    @Override
    public final Bits getDocsWithField(String field2) throws IOException {
        this.ensureOpen();
        Map<String, Bits> dvFields = this.docsWithFieldLocal.get();
        Bits previous = dvFields.get(field2);
        if (previous != null) {
            return previous;
        }
        FieldInfo fi = this.getFieldInfos().fieldInfo(field2);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() == DocValuesType.NONE) {
            return null;
        }
        Bits dv = this.getDocValuesReader().getDocsWithField(fi);
        dvFields.put(field2, dv);
        return dv;
    }

    @Override
    public final BinaryDocValues getBinaryDocValues(String field2) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getDVField(field2, DocValuesType.BINARY);
        if (fi == null) {
            return null;
        }
        Map<String, Object> dvFields = this.docValuesLocal.get();
        BinaryDocValues dvs = (BinaryDocValues)dvFields.get(field2);
        if (dvs == null) {
            dvs = this.getDocValuesReader().getBinary(fi);
            dvFields.put(field2, dvs);
        }
        return dvs;
    }

    @Override
    public final SortedDocValues getSortedDocValues(String field2) throws IOException {
        this.ensureOpen();
        Map<String, Object> dvFields = this.docValuesLocal.get();
        Object previous = dvFields.get(field2);
        if (previous != null && previous instanceof SortedDocValues) {
            return (SortedDocValues)previous;
        }
        FieldInfo fi = this.getDVField(field2, DocValuesType.SORTED);
        if (fi == null) {
            return null;
        }
        SortedDocValues dv = this.getDocValuesReader().getSorted(fi);
        dvFields.put(field2, dv);
        return dv;
    }

    @Override
    public final SortedNumericDocValues getSortedNumericDocValues(String field2) throws IOException {
        this.ensureOpen();
        Map<String, Object> dvFields = this.docValuesLocal.get();
        Object previous = dvFields.get(field2);
        if (previous != null && previous instanceof SortedNumericDocValues) {
            return (SortedNumericDocValues)previous;
        }
        FieldInfo fi = this.getDVField(field2, DocValuesType.SORTED_NUMERIC);
        if (fi == null) {
            return null;
        }
        SortedNumericDocValues dv = this.getDocValuesReader().getSortedNumeric(fi);
        dvFields.put(field2, dv);
        return dv;
    }

    @Override
    public final SortedSetDocValues getSortedSetDocValues(String field2) throws IOException {
        this.ensureOpen();
        Map<String, Object> dvFields = this.docValuesLocal.get();
        Object previous = dvFields.get(field2);
        if (previous != null && previous instanceof SortedSetDocValues) {
            return (SortedSetDocValues)previous;
        }
        FieldInfo fi = this.getDVField(field2, DocValuesType.SORTED_SET);
        if (fi == null) {
            return null;
        }
        SortedSetDocValues dv = this.getDocValuesReader().getSortedSet(fi);
        dvFields.put(field2, dv);
        return dv;
    }

    @Override
    public final NumericDocValues getNormValues(String field2) throws IOException {
        this.ensureOpen();
        Map<String, NumericDocValues> normFields = this.normsLocal.get();
        NumericDocValues norms = normFields.get(field2);
        if (norms != null) {
            return norms;
        }
        FieldInfo fi = this.getFieldInfos().fieldInfo(field2);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        norms = this.getNormsReader().getNorms(fi);
        normFields.put(field2, norms);
        return norms;
    }

    @Override
    protected void doClose() throws IOException {
        IOUtils.close(this.docValuesLocal, this.docsWithFieldLocal, this.normsLocal);
    }

    @Override
    public long ramBytesUsed() {
        this.ensureOpen();
        long ramBytesUsed = this.getPostingsReader().ramBytesUsed();
        if (this.getNormsReader() != null) {
            ramBytesUsed += this.getNormsReader().ramBytesUsed();
        }
        if (this.getDocValuesReader() != null) {
            ramBytesUsed += this.getDocValuesReader().ramBytesUsed();
        }
        if (this.getFieldsReader() != null) {
            ramBytesUsed += this.getFieldsReader().ramBytesUsed();
        }
        if (this.getTermVectorsReader() != null) {
            ramBytesUsed += this.getTermVectorsReader().ramBytesUsed();
        }
        return ramBytesUsed;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        this.ensureOpen();
        ArrayList<Accountable> resources = new ArrayList<Accountable>(5);
        resources.add(Accountables.namedAccountable("postings", this.getPostingsReader()));
        if (this.getNormsReader() != null) {
            resources.add(Accountables.namedAccountable("norms", this.getNormsReader()));
        }
        if (this.getDocValuesReader() != null) {
            resources.add(Accountables.namedAccountable("docvalues", this.getDocValuesReader()));
        }
        if (this.getFieldsReader() != null) {
            resources.add(Accountables.namedAccountable("stored fields", this.getFieldsReader()));
        }
        if (this.getTermVectorsReader() != null) {
            resources.add(Accountables.namedAccountable("term vectors", this.getTermVectorsReader()));
        }
        return Collections.unmodifiableList(resources);
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.ensureOpen();
        this.getPostingsReader().checkIntegrity();
        if (this.getNormsReader() != null) {
            this.getNormsReader().checkIntegrity();
        }
        if (this.getDocValuesReader() != null) {
            this.getDocValuesReader().checkIntegrity();
        }
        if (this.getFieldsReader() != null) {
            this.getFieldsReader().checkIntegrity();
        }
        if (this.getTermVectorsReader() != null) {
            this.getTermVectorsReader().checkIntegrity();
        }
    }
}

