/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SingletonSortedNumericDocValues;
import org.apache.lucene.index.SingletonSortedSetDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public final class DocValues {
    private DocValues() {
    }

    public static final BinaryDocValues emptyBinary() {
        final BytesRef empty = new BytesRef();
        return new BinaryDocValues(){

            @Override
            public BytesRef get(int docID) {
                return empty;
            }
        };
    }

    public static final NumericDocValues emptyNumeric() {
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return 0L;
            }
        };
    }

    public static final SortedDocValues emptySorted() {
        final BytesRef empty = new BytesRef();
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return -1;
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                return empty;
            }

            @Override
            public int getValueCount() {
                return 0;
            }
        };
    }

    public static final SortedNumericDocValues emptySortedNumeric(int maxDoc) {
        return DocValues.singleton(DocValues.emptyNumeric(), new Bits.MatchNoBits(maxDoc));
    }

    public static final RandomAccessOrds emptySortedSet() {
        return DocValues.singleton(DocValues.emptySorted());
    }

    public static RandomAccessOrds singleton(SortedDocValues dv) {
        return new SingletonSortedSetDocValues(dv);
    }

    public static SortedDocValues unwrapSingleton(SortedSetDocValues dv) {
        if (dv instanceof SingletonSortedSetDocValues) {
            return ((SingletonSortedSetDocValues)dv).getSortedDocValues();
        }
        return null;
    }

    public static NumericDocValues unwrapSingleton(SortedNumericDocValues dv) {
        if (dv instanceof SingletonSortedNumericDocValues) {
            return ((SingletonSortedNumericDocValues)dv).getNumericDocValues();
        }
        return null;
    }

    public static Bits unwrapSingletonBits(SortedNumericDocValues dv) {
        if (dv instanceof SingletonSortedNumericDocValues) {
            return ((SingletonSortedNumericDocValues)dv).getDocsWithField();
        }
        return null;
    }

    public static SortedNumericDocValues singleton(NumericDocValues dv, Bits docsWithField) {
        return new SingletonSortedNumericDocValues(dv, docsWithField);
    }

    public static Bits docsWithValue(final SortedDocValues dv, final int maxDoc) {
        return new Bits(){

            @Override
            public boolean get(int index) {
                return dv.getOrd(index) >= 0;
            }

            @Override
            public int length() {
                return maxDoc;
            }
        };
    }

    public static Bits docsWithValue(final SortedSetDocValues dv, final int maxDoc) {
        return new Bits(){

            @Override
            public boolean get(int index) {
                dv.setDocument(index);
                return dv.nextOrd() != -1L;
            }

            @Override
            public int length() {
                return maxDoc;
            }
        };
    }

    public static Bits docsWithValue(final SortedNumericDocValues dv, final int maxDoc) {
        return new Bits(){

            @Override
            public boolean get(int index) {
                dv.setDocument(index);
                return dv.count() != 0;
            }

            @Override
            public int length() {
                return maxDoc;
            }
        };
    }

    private static void checkField(LeafReader in, String field2, DocValuesType ... expected) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field2);
        if (fi != null) {
            DocValuesType actual = fi.getDocValuesType();
            throw new IllegalStateException("unexpected docvalues type " + (Object)((Object)actual) + " for field '" + field2 + "' " + (expected.length == 1 ? "(expected=" + (Object)((Object)expected[0]) : "(expected one of " + Arrays.toString((Object[])expected)) + "). " + "Use UninvertingReader or index with docvalues.");
        }
    }

    public static NumericDocValues getNumeric(LeafReader reader, String field2) throws IOException {
        NumericDocValues dv = reader.getNumericDocValues(field2);
        if (dv == null) {
            DocValues.checkField(reader, field2, DocValuesType.NUMERIC);
            return DocValues.emptyNumeric();
        }
        return dv;
    }

    public static BinaryDocValues getBinary(LeafReader reader, String field2) throws IOException {
        BinaryDocValues dv = reader.getBinaryDocValues(field2);
        if (dv == null && (dv = reader.getSortedDocValues(field2)) == null) {
            DocValues.checkField(reader, field2, DocValuesType.BINARY, DocValuesType.SORTED);
            return DocValues.emptyBinary();
        }
        return dv;
    }

    public static SortedDocValues getSorted(LeafReader reader, String field2) throws IOException {
        SortedDocValues dv = reader.getSortedDocValues(field2);
        if (dv == null) {
            DocValues.checkField(reader, field2, DocValuesType.SORTED);
            return DocValues.emptySorted();
        }
        return dv;
    }

    public static SortedNumericDocValues getSortedNumeric(LeafReader reader, String field2) throws IOException {
        SortedNumericDocValues dv = reader.getSortedNumericDocValues(field2);
        if (dv == null) {
            NumericDocValues single = reader.getNumericDocValues(field2);
            if (single == null) {
                DocValues.checkField(reader, field2, DocValuesType.SORTED_NUMERIC, DocValuesType.NUMERIC);
                return DocValues.emptySortedNumeric(reader.maxDoc());
            }
            Bits bits = reader.getDocsWithField(field2);
            return DocValues.singleton(single, bits);
        }
        return dv;
    }

    public static SortedSetDocValues getSortedSet(LeafReader reader, String field2) throws IOException {
        SortedSetDocValues dv = reader.getSortedSetDocValues(field2);
        if (dv == null) {
            SortedDocValues sorted = reader.getSortedDocValues(field2);
            if (sorted == null) {
                DocValues.checkField(reader, field2, DocValuesType.SORTED, DocValuesType.SORTED_SET);
                return DocValues.emptySortedSet();
            }
            return DocValues.singleton(sorted);
        }
        return dv;
    }

    public static Bits getDocsWithField(LeafReader reader, String field2) throws IOException {
        Bits dv = reader.getDocsWithField(field2);
        if (dv == null) {
            assert (DocValuesType.values().length == 6);
            DocValues.checkField(reader, field2, DocValuesType.BINARY, DocValuesType.NUMERIC, DocValuesType.SORTED, DocValuesType.SORTED_NUMERIC, DocValuesType.SORTED_SET);
            return new Bits.MatchNoBits(reader.maxDoc());
        }
        return dv;
    }
}

