/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.NumericDocValuesFieldUpdates;

abstract class DocValuesFieldUpdates {
    protected static final int PAGE_SIZE = 1024;
    final String field;
    final DocValuesType type;

    protected DocValuesFieldUpdates(String field2, DocValuesType type) {
        this.field = field2;
        if (type == null) {
            throw new NullPointerException("DocValuesType cannot be null");
        }
        this.type = type;
    }

    protected static int estimateCapacity(int size) {
        return (int)Math.ceil((double)size / 1024.0) * 1024;
    }

    public abstract void add(int var1, Object var2);

    public abstract Iterator iterator();

    public abstract void merge(DocValuesFieldUpdates var1);

    public abstract boolean any();

    public abstract long ramBytesPerDoc();

    static class Container {
        final Map<String, NumericDocValuesFieldUpdates> numericDVUpdates = new HashMap<String, NumericDocValuesFieldUpdates>();
        final Map<String, BinaryDocValuesFieldUpdates> binaryDVUpdates = new HashMap<String, BinaryDocValuesFieldUpdates>();

        Container() {
        }

        boolean any() {
            for (NumericDocValuesFieldUpdates numericDocValuesFieldUpdates : this.numericDVUpdates.values()) {
                if (!numericDocValuesFieldUpdates.any()) continue;
                return true;
            }
            for (BinaryDocValuesFieldUpdates binaryDocValuesFieldUpdates : this.binaryDVUpdates.values()) {
                if (!binaryDocValuesFieldUpdates.any()) continue;
                return true;
            }
            return false;
        }

        int size() {
            return this.numericDVUpdates.size() + this.binaryDVUpdates.size();
        }

        long ramBytesPerDoc() {
            long ramBytesPerDoc = 0L;
            for (NumericDocValuesFieldUpdates numericDocValuesFieldUpdates : this.numericDVUpdates.values()) {
                ramBytesPerDoc += numericDocValuesFieldUpdates.ramBytesPerDoc();
            }
            for (BinaryDocValuesFieldUpdates binaryDocValuesFieldUpdates : this.binaryDVUpdates.values()) {
                ramBytesPerDoc += binaryDocValuesFieldUpdates.ramBytesPerDoc();
            }
            return ramBytesPerDoc;
        }

        DocValuesFieldUpdates getUpdates(String field2, DocValuesType type) {
            switch (type) {
                case NUMERIC: {
                    return this.numericDVUpdates.get(field2);
                }
                case BINARY: {
                    return this.binaryDVUpdates.get(field2);
                }
            }
            throw new IllegalArgumentException("unsupported type: " + (Object)((Object)type));
        }

        DocValuesFieldUpdates newUpdates(String field2, DocValuesType type, int maxDoc) {
            switch (type) {
                case NUMERIC: {
                    assert (this.numericDVUpdates.get(field2) == null);
                    NumericDocValuesFieldUpdates numericUpdates = new NumericDocValuesFieldUpdates(field2, maxDoc);
                    this.numericDVUpdates.put(field2, numericUpdates);
                    return numericUpdates;
                }
                case BINARY: {
                    assert (this.binaryDVUpdates.get(field2) == null);
                    BinaryDocValuesFieldUpdates binaryUpdates = new BinaryDocValuesFieldUpdates(field2, maxDoc);
                    this.binaryDVUpdates.put(field2, binaryUpdates);
                    return binaryUpdates;
                }
            }
            throw new IllegalArgumentException("unsupported type: " + (Object)((Object)type));
        }

        public String toString() {
            return "numericDVUpdates=" + this.numericDVUpdates + " binaryDVUpdates=" + this.binaryDVUpdates;
        }
    }

    static abstract class Iterator {
        Iterator() {
        }

        abstract int nextDoc();

        abstract int doc();

        abstract Object value();

        abstract void reset();
    }
}

