/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.util.ThreadInterruptedException;

public class MergeRateLimiter
extends RateLimiter {
    private static final int MIN_PAUSE_CHECK_MSEC = 25;
    volatile long totalBytesWritten;
    double mbPerSec;
    private long lastNS;
    private long minPauseCheckBytes;
    private boolean abort;
    long totalPausedNS;
    long totalStoppedNS;
    final MergePolicy.OneMerge merge;

    public MergeRateLimiter(MergePolicy.OneMerge merge) {
        this.merge = merge;
        this.setMBPerSec(Double.POSITIVE_INFINITY);
    }

    @Override
    public synchronized void setMBPerSec(double mbPerSec) {
        if (mbPerSec < 0.0) {
            throw new IllegalArgumentException("mbPerSec must be positive; got: " + mbPerSec);
        }
        this.mbPerSec = mbPerSec;
        this.minPauseCheckBytes = Math.min(0x100000L, (long)(0.025 * mbPerSec * 1024.0 * 1024.0));
        assert (this.minPauseCheckBytes >= 0L);
        this.notify();
    }

    @Override
    public synchronized double getMBPerSec() {
        return this.mbPerSec;
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    @Override
    public long pause(long bytes) throws MergePolicy.MergeAbortedException {
        long startNS;
        this.totalBytesWritten += bytes;
        long curNS = startNS = System.nanoTime();
        long pausedNS = 0L;
        while (true) {
            PauseResult result2;
            if ((result2 = this.maybePause(bytes, curNS)) == PauseResult.NO) break;
            curNS = System.nanoTime();
            long ns = curNS - startNS;
            startNS = curNS;
            if (result2 == PauseResult.STOPPED) {
                this.totalStoppedNS += ns;
            } else {
                assert (result2 == PauseResult.PAUSED);
                this.totalPausedNS += ns;
            }
            pausedNS += ns;
        }
        this.lastNS = curNS;
        return pausedNS;
    }

    public synchronized long getTotalStoppedNS() {
        return this.totalStoppedNS;
    }

    public synchronized long getTotalPausedNS() {
        return this.totalPausedNS;
    }

    private synchronized PauseResult maybePause(long bytes, long curNS) throws MergePolicy.MergeAbortedException {
        this.checkAbort();
        double secondsToPause = (double)bytes / 1024.0 / 1024.0 / this.mbPerSec;
        long targetNS = this.lastNS + (long)(1.0E9 * secondsToPause);
        long curPauseNS = targetNS - curNS;
        if (curPauseNS <= 2000000L) {
            return PauseResult.NO;
        }
        if (curPauseNS > 250000000L) {
            curPauseNS = 250000000L;
        }
        int sleepMS = (int)(curPauseNS / 1000000L);
        int sleepNS = (int)(curPauseNS % 1000000L);
        double rate = this.mbPerSec;
        try {
            this.wait(sleepMS, sleepNS);
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException(ie);
        }
        if (rate == 0.0) {
            return PauseResult.STOPPED;
        }
        return PauseResult.PAUSED;
    }

    public synchronized void checkAbort() throws MergePolicy.MergeAbortedException {
        if (this.abort) {
            throw new MergePolicy.MergeAbortedException("merge is aborted: " + this.merge.segString());
        }
    }

    public synchronized void setAbort() {
        this.abort = true;
        this.notify();
    }

    public synchronized boolean getAbort() {
        return this.abort;
    }

    @Override
    public long getMinPauseCheckBytes() {
        return this.minPauseCheckBytes;
    }

    private static enum PauseResult {
        NO,
        STOPPED,
        PAUSED;

    }
}

