/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class BoostingQuery
extends Query {
    private final float boost;
    private final Query match;
    private final Query context;

    public BoostingQuery(Query match, Query context, float boost) {
        this.match = match;
        this.context = context;
        this.boost = boost;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query matchRewritten = this.match.rewrite(reader);
        Query contextRewritten = this.context.rewrite(reader);
        if (this.match != matchRewritten || this.context != contextRewritten) {
            return new BoostingQuery(matchRewritten, contextRewritten, this.boost);
        }
        return super.rewrite(reader);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        if (!needsScores) {
            return this.match.createWeight(searcher, needsScores);
        }
        final Weight matchWeight = searcher.createWeight(this.match, needsScores);
        final Weight contextWeight = searcher.createWeight(this.context, false);
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
                matchWeight.extractTerms(terms);
                if (BoostingQuery.this.boost >= 1.0f) {
                    contextWeight.extractTerms(terms);
                }
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Explanation matchExplanation = matchWeight.explain(context, doc);
                Explanation contextExplanation = contextWeight.explain(context, doc);
                if (!matchExplanation.isMatch() || !contextExplanation.isMatch()) {
                    return matchExplanation;
                }
                return Explanation.match(matchExplanation.getValue() * BoostingQuery.this.boost, "product of:", matchExplanation, Explanation.match(BoostingQuery.this.boost, "boost", new Explanation[0]));
            }

            @Override
            public float getValueForNormalization() throws IOException {
                return matchWeight.getValueForNormalization();
            }

            @Override
            public void normalize(float norm, float boost) {
                matchWeight.normalize(norm, boost);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                Scorer matchScorer = matchWeight.scorer(context);
                if (matchScorer == null) {
                    return null;
                }
                Scorer contextScorer = contextWeight.scorer(context);
                if (contextScorer == null) {
                    return matchScorer;
                }
                final TwoPhaseIterator contextTwoPhase = contextScorer.twoPhaseIterator();
                final DocIdSetIterator contextApproximation = contextTwoPhase == null ? contextScorer.iterator() : contextTwoPhase.approximation();
                return new FilterScorer(matchScorer){

                    @Override
                    public float score() throws IOException {
                        if (contextApproximation.docID() < this.docID()) {
                            contextApproximation.advance(this.docID());
                        }
                        assert (contextApproximation.docID() >= this.docID());
                        float score = super.score();
                        if (contextApproximation.docID() == this.docID() && (contextTwoPhase == null || contextTwoPhase.matches())) {
                            score *= BoostingQuery.this.boost;
                        }
                        return score;
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.match, this.context, Float.valueOf(this.boost));
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BoostingQuery that = (BoostingQuery)obj;
        return this.match.equals(that.match) && this.context.equals(that.context) && Float.floatToIntBits(this.boost) == Float.floatToIntBits(that.boost);
    }

    @Override
    public String toString(String field2) {
        return this.match.toString(field2) + "/" + this.context.toString(field2) + ToStringUtils.boost(this.getBoost());
    }
}

