/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard.builders;

import org.apache.lucene.document.FieldType;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.messages.QueryParserMessages;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.util.StringUtils;
import org.apache.lucene.queryparser.flexible.messages.MessageImpl;
import org.apache.lucene.queryparser.flexible.standard.builders.StandardQueryBuilder;
import org.apache.lucene.queryparser.flexible.standard.config.NumericConfig;
import org.apache.lucene.queryparser.flexible.standard.nodes.NumericQueryNode;
import org.apache.lucene.queryparser.flexible.standard.nodes.NumericRangeQueryNode;
import org.apache.lucene.search.NumericRangeQuery;

public class NumericRangeQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public NumericRangeQuery<? extends Number> build(QueryNode queryNode) throws QueryNodeException {
        NumericRangeQueryNode numericRangeNode = (NumericRangeQueryNode)queryNode;
        NumericQueryNode lowerNumericNode = (NumericQueryNode)numericRangeNode.getLowerBound();
        NumericQueryNode upperNumericNode = (NumericQueryNode)numericRangeNode.getUpperBound();
        Number lowerNumber = lowerNumericNode.getValue();
        Number upperNumber = upperNumericNode.getValue();
        NumericConfig numericConfig = numericRangeNode.getNumericConfig();
        FieldType.NumericType numberType = numericConfig.getType();
        String field2 = StringUtils.toString(numericRangeNode.getField());
        boolean minInclusive = numericRangeNode.isLowerInclusive();
        boolean maxInclusive = numericRangeNode.isUpperInclusive();
        int precisionStep = numericConfig.getPrecisionStep();
        switch (numberType) {
            case LONG: {
                return NumericRangeQuery.newLongRange(field2, precisionStep, (Long)lowerNumber, (Long)upperNumber, minInclusive, maxInclusive);
            }
            case INT: {
                return NumericRangeQuery.newIntRange(field2, precisionStep, (Integer)lowerNumber, (Integer)upperNumber, minInclusive, maxInclusive);
            }
            case FLOAT: {
                return NumericRangeQuery.newFloatRange(field2, precisionStep, (Float)lowerNumber, (Float)upperNumber, minInclusive, maxInclusive);
            }
            case DOUBLE: {
                return NumericRangeQuery.newDoubleRange(field2, precisionStep, (Double)lowerNumber, (Double)upperNumber, minInclusive, maxInclusive);
            }
        }
        throw new QueryNodeException(new MessageImpl(QueryParserMessages.UNSUPPORTED_NUMERIC_DATA_TYPE, new Object[]{numberType}));
    }
}

