/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.rangetree;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.rangetree.RangeTreeReader;
import org.apache.lucene.rangetree.RangeTreeSortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class NumericRangeTreeQuery
extends Query {
    final String field;
    final Long minValue;
    final Long maxValue;
    final boolean minInclusive;
    final boolean maxInclusive;

    public NumericRangeTreeQuery(String field2, Long minValue, boolean minInclusive, Long maxValue, boolean maxInclusive) {
        this.field = field2;
        this.minInclusive = minInclusive;
        this.minValue = minValue;
        this.maxInclusive = maxInclusive;
        this.maxValue = maxValue;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                long maxBoundIncl;
                long minBoundIncl;
                LeafReader reader = context.reader();
                SortedNumericDocValues sdv = reader.getSortedNumericDocValues(NumericRangeTreeQuery.this.field);
                if (sdv == null) {
                    return null;
                }
                if (!(sdv instanceof RangeTreeSortedNumericDocValues)) {
                    throw new IllegalStateException("field \"" + NumericRangeTreeQuery.this.field + "\" was not indexed with RangeTreeDocValuesFormat: got: " + sdv);
                }
                RangeTreeSortedNumericDocValues treeDV = (RangeTreeSortedNumericDocValues)sdv;
                RangeTreeReader tree = treeDV.getRangeTreeReader();
                long l = minBoundIncl = NumericRangeTreeQuery.this.minValue == null ? Long.MIN_VALUE : NumericRangeTreeQuery.this.minValue;
                if (!NumericRangeTreeQuery.this.minInclusive && NumericRangeTreeQuery.this.minValue != null) {
                    if (minBoundIncl == Long.MAX_VALUE) {
                        return null;
                    }
                    ++minBoundIncl;
                }
                long l2 = maxBoundIncl = NumericRangeTreeQuery.this.maxValue == null ? Long.MAX_VALUE : NumericRangeTreeQuery.this.maxValue;
                if (!NumericRangeTreeQuery.this.maxInclusive && NumericRangeTreeQuery.this.maxValue != null) {
                    if (maxBoundIncl == Long.MIN_VALUE) {
                        return null;
                    }
                    --maxBoundIncl;
                }
                if (maxBoundIncl < minBoundIncl) {
                    return null;
                }
                DocIdSet result2 = tree.intersect(minBoundIncl, maxBoundIncl, treeDV.delegate, context.reader().maxDoc());
                DocIdSetIterator disi = result2.iterator();
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }
        };
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (this.minValue != null) {
            hash += this.minValue.hashCode() ^ 0x14FA55FB;
        }
        if (this.maxValue != null) {
            hash += this.maxValue.hashCode() ^ 0x733FA5FE;
        }
        return hash + (Boolean.valueOf(this.minInclusive).hashCode() ^ 0x14FA55FB) + (Boolean.valueOf(this.maxInclusive).hashCode() ^ 0x733FA5FE);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            NumericRangeTreeQuery q = (NumericRangeTreeQuery)other;
            return (q.minValue == null ? this.minValue == null : q.minValue.equals(this.minValue)) && (q.maxValue == null ? this.maxValue == null : q.maxValue.equals(this.maxValue)) && this.minInclusive == q.minInclusive && this.maxInclusive == q.maxInclusive;
        }
        return false;
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field2)) {
            sb.append("field=");
            sb.append(this.field);
            sb.append(':');
        }
        return sb.append(this.minInclusive ? (char)'[' : '{').append(this.minValue == null ? "*" : this.minValue.toString()).append(" TO ").append(this.maxValue == null ? "*" : this.maxValue.toString()).append(this.maxInclusive ? (char)']' : '}').append(ToStringUtils.boost(this.getBoost())).toString();
    }
}

