/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.queries;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.SparseFixedBitSet;

@Deprecated
public class DuplicateFilter
extends Filter {
    private KeepMode keepMode;
    private ProcessingMode processingMode;
    private String fieldName;

    public DuplicateFilter(String fieldName) {
        this(fieldName, KeepMode.KM_USE_LAST_OCCURRENCE, ProcessingMode.PM_FULL_VALIDATION);
    }

    public DuplicateFilter(String fieldName, KeepMode keepMode, ProcessingMode processingMode) {
        this.fieldName = fieldName;
        this.keepMode = keepMode;
        this.processingMode = processingMode;
    }

    @Override
    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        if (this.processingMode == ProcessingMode.PM_FAST_INVALIDATION) {
            return this.fastBits(context.reader(), acceptDocs);
        }
        return this.correctBits(context.reader(), acceptDocs);
    }

    private DocIdSet correctBits(LeafReader reader, Bits acceptDocs) throws IOException {
        SparseFixedBitSet bits = new SparseFixedBitSet(reader.maxDoc());
        Terms terms = reader.fields().terms(this.fieldName);
        if (terms != null) {
            BytesRef currTerm;
            TermsEnum termsEnum = terms.iterator();
            PostingsEnum docs = null;
            while ((currTerm = termsEnum.next()) != null) {
                int doc = (docs = termsEnum.postings(docs, 0)).nextDoc();
                if (doc == Integer.MAX_VALUE) continue;
                if (this.keepMode == KeepMode.KM_USE_FIRST_OCCURRENCE) {
                    bits.set(doc);
                    continue;
                }
                int lastDoc = doc;
                do {
                    lastDoc = doc;
                } while ((doc = docs.nextDoc()) != Integer.MAX_VALUE);
                bits.set(lastDoc);
            }
        }
        return BitsFilteredDocIdSet.wrap(new BitDocIdSet(bits, bits.approximateCardinality()), acceptDocs);
    }

    private DocIdSet fastBits(LeafReader reader, Bits acceptDocs) throws IOException {
        FixedBitSet bits = new FixedBitSet(reader.maxDoc());
        bits.set(0, reader.maxDoc());
        Terms terms = reader.fields().terms(this.fieldName);
        if (terms != null) {
            BytesRef currTerm;
            TermsEnum termsEnum = terms.iterator();
            PostingsEnum docs = null;
            while ((currTerm = termsEnum.next()) != null) {
                if (termsEnum.docFreq() <= 1) continue;
                int doc = (docs = termsEnum.postings(docs, 0)).nextDoc();
                if (doc != Integer.MAX_VALUE && this.keepMode == KeepMode.KM_USE_FIRST_OCCURRENCE) {
                    doc = docs.nextDoc();
                }
                int lastDoc = -1;
                do {
                    lastDoc = doc;
                    bits.clear(lastDoc);
                } while ((doc = docs.nextDoc()) != Integer.MAX_VALUE);
                if (this.keepMode != KeepMode.KM_USE_LAST_OCCURRENCE) continue;
                bits.set(lastDoc);
            }
        }
        return BitsFilteredDocIdSet.wrap(new BitDocIdSet(bits), acceptDocs);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public KeepMode getKeepMode() {
        return this.keepMode;
    }

    public void setKeepMode(KeepMode keepMode) {
        this.keepMode = keepMode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DuplicateFilter other = (DuplicateFilter)obj;
        return this.keepMode == other.keepMode && this.processingMode == other.processingMode && this.fieldName != null && this.fieldName.equals(other.fieldName);
    }

    @Override
    public String toString(String field2) {
        return "DuplicateFilter(fieldName=" + this.fieldName + "," + "keepMode=" + (this.keepMode == KeepMode.KM_USE_FIRST_OCCURRENCE ? "first" : "last") + "," + "processingMode=" + (this.processingMode == ProcessingMode.PM_FAST_INVALIDATION ? "fast" : "full") + ")";
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.keepMode.hashCode();
        hash = 31 * hash + this.processingMode.hashCode();
        hash = 31 * hash + this.fieldName.hashCode();
        return hash;
    }

    public ProcessingMode getProcessingMode() {
        return this.processingMode;
    }

    public void setProcessingMode(ProcessingMode processingMode) {
        this.processingMode = processingMode;
    }

    public static enum ProcessingMode {
        PM_FULL_VALIDATION,
        PM_FAST_INVALIDATION;

    }

    public static enum KeepMode {
        KM_USE_FIRST_OCCURRENCE,
        KM_USE_LAST_OCCURRENCE;

    }
}

