/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.queries;

import java.io.IOException;
import org.apache.lucene.index.SingleTermsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.sandbox.queries.SlowFuzzyTermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.ToStringUtils;

@Deprecated
public class SlowFuzzyQuery
extends MultiTermQuery {
    public static final float defaultMinSimilarity = 2.0f;
    public static final int defaultPrefixLength = 0;
    public static final int defaultMaxExpansions = 50;
    private float minimumSimilarity;
    private int prefixLength;
    private boolean termLongEnough = false;
    protected Term term;

    public SlowFuzzyQuery(Term term, float minimumSimilarity, int prefixLength, int maxExpansions) {
        super(term.field());
        this.term = term;
        if (minimumSimilarity >= 1.0f && minimumSimilarity != (float)((int)minimumSimilarity)) {
            throw new IllegalArgumentException("fractional edit distances are not allowed");
        }
        if (minimumSimilarity < 0.0f) {
            throw new IllegalArgumentException("minimumSimilarity < 0");
        }
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength < 0");
        }
        if (maxExpansions < 0) {
            throw new IllegalArgumentException("maxExpansions < 0");
        }
        this.setRewriteMethod(new MultiTermQuery.TopTermsScoringBooleanQueryRewrite(maxExpansions));
        String text = term.text();
        int len = text.codePointCount(0, text.length());
        if (len > 0 && (minimumSimilarity >= 1.0f || (float)len > 1.0f / (1.0f - minimumSimilarity))) {
            this.termLongEnough = true;
        }
        this.minimumSimilarity = minimumSimilarity;
        this.prefixLength = prefixLength;
    }

    public SlowFuzzyQuery(Term term, float minimumSimilarity, int prefixLength) {
        this(term, minimumSimilarity, prefixLength, 50);
    }

    public SlowFuzzyQuery(Term term, float minimumSimilarity) {
        this(term, minimumSimilarity, 0, 50);
    }

    public SlowFuzzyQuery(Term term) {
        this(term, 2.0f, 0, 50);
    }

    public float getMinSimilarity() {
        return this.minimumSimilarity;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        if (!this.termLongEnough) {
            return new SingleTermsEnum(terms.iterator(), this.term.bytes());
        }
        return new SlowFuzzyTermsEnum(terms, atts, this.getTerm(), this.minimumSimilarity, this.prefixLength);
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public String toString(String field2) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field2)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append('~');
        buffer.append(Float.toString(this.minimumSimilarity));
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + Float.floatToIntBits(this.minimumSimilarity);
        result2 = 31 * result2 + this.prefixLength;
        result2 = 31 * result2 + (this.term == null ? 0 : this.term.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SlowFuzzyQuery other = (SlowFuzzyQuery)obj;
        if (Float.floatToIntBits(this.minimumSimilarity) != Float.floatToIntBits(other.minimumSimilarity)) {
            return false;
        }
        if (this.prefixLength != other.prefixLength) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }
}

