/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.WildcardQuery;

public final class BoostQuery
extends Query {
    private static final Set<Class<? extends Query>> NO_PARENS_REQUIRED_QUERIES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(MatchAllDocsQuery.class, TermQuery.class, PhraseQuery.class, MultiPhraseQuery.class, ConstantScoreQuery.class, TermRangeQuery.class, NumericRangeQuery.class, PrefixQuery.class, FuzzyQuery.class, WildcardQuery.class, RegexpQuery.class)));
    private final Query query;

    public BoostQuery(Query query, float boost) {
        this.query = Objects.requireNonNull(query);
        this.setBoost(boost);
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public float getBoost() {
        return super.getBoost();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BoostQuery that = (BoostQuery)obj;
        return this.query.equals(that.query);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = 31 * h + this.query.hashCode();
        return h;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (this.getBoost() == 1.0f) {
            return rewritten;
        }
        if (rewritten.getClass() == BoostQuery.class) {
            BoostQuery in = (BoostQuery)rewritten;
            return new BoostQuery(in.query, this.getBoost() * in.getBoost());
        }
        if (this.getBoost() == 0.0f && rewritten.getClass() != ConstantScoreQuery.class) {
            return new BoostQuery(new ConstantScoreQuery(rewritten), 0.0f);
        }
        if (this.query != rewritten) {
            return new BoostQuery(rewritten, this.getBoost());
        }
        return this;
    }

    @Override
    public String toString(String field2) {
        boolean needsParens = !NO_PARENS_REQUIRED_QUERIES.contains(this.query.getClass());
        StringBuilder builder = new StringBuilder();
        if (needsParens) {
            builder.append("(");
        }
        builder.append(this.query.toString(field2));
        if (needsParens) {
            builder.append(")");
        }
        builder.append("^");
        builder.append(this.getBoost());
        return builder.toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight weight = this.query.createWeight(searcher, needsScores);
        if (!needsScores) {
            return weight;
        }
        weight.normalize(1.0f, this.getBoost());
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
                weight.extractTerms(terms);
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return weight.explain(context, doc);
            }

            @Override
            public float getValueForNormalization() throws IOException {
                return weight.getValueForNormalization();
            }

            @Override
            public void normalize(float norm, float boost) {
                weight.normalize(norm, BoostQuery.this.getBoost() * boost);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return weight.scorer(context);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                return weight.bulkScorer(context);
            }
        };
    }
}

