/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocValuesDocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;

@Deprecated
public class DocValuesTermsFilter
extends Filter {
    private String field;
    private BytesRef[] terms;

    public DocValuesTermsFilter(String field2, BytesRef ... terms) {
        this.field = field2;
        this.terms = terms;
    }

    public DocValuesTermsFilter(String field2, String ... terms) {
        this.field = field2;
        this.terms = new BytesRef[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            this.terms[i] = new BytesRef(terms[i]);
        }
    }

    @Override
    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        final SortedDocValues fcsi = DocValues.getSorted(context.reader(), this.field);
        final FixedBitSet bits = new FixedBitSet(fcsi.getValueCount());
        for (int i = 0; i < this.terms.length; ++i) {
            int ord = fcsi.lookupTerm(this.terms[i]);
            if (ord < 0) continue;
            bits.set(ord);
        }
        return new DocValuesDocIdSet(context.reader().maxDoc(), acceptDocs){

            @Override
            protected final boolean matchDoc(int doc) {
                int ord = fcsi.getOrd(doc);
                if (ord == -1) {
                    return false;
                }
                return bits.get(ord);
            }
        };
    }

    @Override
    public String toString(String defaultField) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.field).append(": [");
        for (BytesRef term : this.terms) {
            sb.append(term).append(", ");
        }
        if (this.terms.length > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.append(']').toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DocValuesTermsFilter other = (DocValuesTermsFilter)obj;
        return this.field.equals(other.field) && Arrays.equals(this.terms, other.terms);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Arrays.hashCode(this.terms);
        return h;
    }
}

