/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;

public class TermRangeQuery
extends AutomatonQuery {
    private final BytesRef lowerTerm;
    private final BytesRef upperTerm;
    private final boolean includeLower;
    private final boolean includeUpper;

    public TermRangeQuery(String field2, BytesRef lowerTerm, BytesRef upperTerm, boolean includeLower, boolean includeUpper) {
        super(new Term(field2, lowerTerm), TermRangeQuery.toAutomaton(lowerTerm, upperTerm, includeLower, includeUpper), Integer.MAX_VALUE, true);
        this.lowerTerm = lowerTerm;
        this.upperTerm = upperTerm;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public static Automaton toAutomaton(BytesRef lowerTerm, BytesRef upperTerm, boolean includeLower, boolean includeUpper) {
        if (lowerTerm == null) {
            includeLower = true;
        }
        if (upperTerm == null) {
            includeUpper = true;
        }
        return Automata.makeBinaryInterval(lowerTerm, includeLower, upperTerm, includeUpper);
    }

    public static TermRangeQuery newStringRange(String field2, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        BytesRef lower = lowerTerm == null ? null : new BytesRef(lowerTerm);
        BytesRef upper = upperTerm == null ? null : new BytesRef(upperTerm);
        return new TermRangeQuery(field2, lower, upper, includeLower, includeUpper);
    }

    public BytesRef getLowerTerm() {
        return this.lowerTerm;
    }

    public BytesRef getUpperTerm() {
        return this.upperTerm;
    }

    public boolean includesLower() {
        return this.includeLower;
    }

    public boolean includesUpper() {
        return this.includeUpper;
    }

    @Override
    public String toString(String field2) {
        StringBuilder buffer = new StringBuilder();
        if (!this.getField().equals(field2)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.includeLower ? (char)'[' : '{');
        buffer.append(this.lowerTerm != null ? ("*".equals(Term.toString(this.lowerTerm)) ? "\\*" : Term.toString(this.lowerTerm)) : "*");
        buffer.append(" TO ");
        buffer.append(this.upperTerm != null ? ("*".equals(Term.toString(this.upperTerm)) ? "\\*" : Term.toString(this.upperTerm)) : "*");
        buffer.append(this.includeUpper ? (char)']' : '}');
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.includeLower ? 1231 : 1237);
        result2 = 31 * result2 + (this.includeUpper ? 1231 : 1237);
        result2 = 31 * result2 + (this.lowerTerm == null ? 0 : this.lowerTerm.hashCode());
        result2 = 31 * result2 + (this.upperTerm == null ? 0 : this.upperTerm.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TermRangeQuery other = (TermRangeQuery)obj;
        if (this.includeLower != other.includeLower) {
            return false;
        }
        if (this.includeUpper != other.includeUpper) {
            return false;
        }
        if (this.lowerTerm == null ? other.lowerTerm != null : !this.lowerTerm.equals(other.lowerTerm)) {
            return false;
        }
        return !(this.upperTerm == null ? other.upperTerm != null : !this.upperTerm.equals(other.upperTerm));
    }
}

