/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.NearSpansOrdered;
import org.apache.lucene.search.spans.NearSpansUnordered;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanNearQuery
extends SpanQuery
implements Cloneable {
    protected List<SpanQuery> clauses;
    protected int slop;
    protected boolean inOrder;
    protected String field;

    public static Builder newOrderedNearQuery(String field2) {
        return new Builder(field2, true);
    }

    public static Builder newUnorderedNearQuery(String field2) {
        return new Builder(field2, false);
    }

    public SpanNearQuery(SpanQuery[] clauses, int slop, boolean inOrder) {
        this(clauses, slop, inOrder, true);
    }

    @Deprecated
    public SpanNearQuery(SpanQuery[] clausesIn, int slop, boolean inOrder, boolean collectPayloads) {
        this.clauses = new ArrayList<SpanQuery>(clausesIn.length);
        for (SpanQuery clause : clausesIn) {
            if (this.field == null) {
                this.field = clause.getField();
            } else if (clause.getField() != null && !clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(clause);
        }
        this.slop = slop;
        this.inOrder = inOrder;
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    public int getSlop() {
        return this.slop;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public String toString(String field2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanNear([");
        Iterator<SpanQuery> i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = i.next();
            buffer.append(clause.toString(field2));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("], ");
        buffer.append(this.slop);
        buffer.append(", ");
        buffer.append(this.inOrder);
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        ArrayList<SpanWeight> subWeights = new ArrayList<SpanWeight>();
        for (SpanQuery q : this.clauses) {
            subWeights.add(q.createWeight(searcher, false));
        }
        return new SpanNearWeight(subWeights, searcher, needsScores ? SpanNearQuery.getTermContexts(subWeights) : null);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        boolean actuallyRewritten = false;
        ArrayList<SpanQuery> rewrittenClauses = new ArrayList<SpanQuery>();
        for (int i = 0; i < this.clauses.size(); ++i) {
            SpanQuery c = this.clauses.get(i);
            SpanQuery query = (SpanQuery)c.rewrite(reader);
            actuallyRewritten |= query != c;
            rewrittenClauses.add(query);
        }
        if (actuallyRewritten) {
            SpanNearQuery rewritten = (SpanNearQuery)this.clone();
            rewritten.clauses = rewrittenClauses;
            return rewritten;
        }
        return super.rewrite(reader);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SpanNearQuery spanNearQuery = (SpanNearQuery)o;
        return this.inOrder == spanNearQuery.inOrder && this.slop == spanNearQuery.slop && this.clauses.equals(spanNearQuery.clauses);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 ^= this.clauses.hashCode();
        int fac = 1 + (this.inOrder ? 8 : 4);
        return fac * (result2 += this.slop);
    }

    static class GapSpans
    extends Spans {
        int doc = -1;
        int pos = -1;
        final int width;

        GapSpans(int width) {
            this.width = width;
        }

        @Override
        public int nextStartPosition() throws IOException {
            return ++this.pos;
        }

        public int skipToPosition(int position) throws IOException {
            this.pos = position;
            return this.pos;
        }

        @Override
        public int startPosition() {
            return this.pos;
        }

        @Override
        public int endPosition() {
            return this.pos + this.width;
        }

        @Override
        public int width() {
            return this.width;
        }

        @Override
        public void collect(SpanCollector collector) throws IOException {
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            this.pos = -1;
            return ++this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            this.pos = -1;
            this.doc = target;
            return this.doc;
        }

        @Override
        public long cost() {
            return 0L;
        }

        @Override
        public float positionsCost() {
            return 0.0f;
        }
    }

    private static class SpanGapQuery
    extends SpanQuery {
        private final String field;
        private final int width;

        public SpanGapQuery(String field2, int width) {
            this.field = field2;
            this.width = width;
        }

        @Override
        public String getField() {
            return this.field;
        }

        @Override
        public String toString(String field2) {
            return "SpanGap(" + field2 + ":" + this.width + ")";
        }

        @Override
        public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            return new SpanGapWeight(searcher);
        }

        private class SpanGapWeight
        extends SpanWeight {
            SpanGapWeight(IndexSearcher searcher) throws IOException {
                super(SpanGapQuery.this, searcher, null);
            }

            @Override
            public void extractTermContexts(Map<Term, TermContext> contexts) {
            }

            @Override
            public Spans getSpans(LeafReaderContext ctx, SpanWeight.Postings requiredPostings) throws IOException {
                return new GapSpans(SpanGapQuery.this.width);
            }

            @Override
            public void extractTerms(Set<Term> terms) {
            }
        }
    }

    public class SpanNearWeight
    extends SpanWeight {
        final List<SpanWeight> subWeights;

        public SpanNearWeight(List<SpanWeight> subWeights, IndexSearcher searcher, Map<Term, TermContext> terms) throws IOException {
            super(SpanNearQuery.this, searcher, terms);
            this.subWeights = subWeights;
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            for (SpanWeight w : this.subWeights) {
                w.extractTermContexts(contexts);
            }
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            Terms terms = context.reader().terms(this.field);
            if (terms == null) {
                return null;
            }
            ArrayList<Spans> subSpans = new ArrayList<Spans>(SpanNearQuery.this.clauses.size());
            for (SpanWeight w : this.subWeights) {
                Spans subSpan = w.getSpans(context, requiredPostings);
                if (subSpan != null) {
                    subSpans.add(subSpan);
                    continue;
                }
                return null;
            }
            return !SpanNearQuery.this.inOrder ? new NearSpansUnordered(SpanNearQuery.this.slop, subSpans) : new NearSpansOrdered(SpanNearQuery.this.slop, subSpans);
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            for (SpanWeight w : this.subWeights) {
                w.extractTerms(terms);
            }
        }
    }

    public static class Builder {
        private final boolean ordered;
        private final String field;
        private final List<SpanQuery> clauses = new LinkedList<SpanQuery>();
        private int slop;

        public Builder(String field2, boolean ordered) {
            this.field = field2;
            this.ordered = ordered;
        }

        public Builder addClause(SpanQuery clause) {
            if (!Objects.equals(clause.getField(), this.field)) {
                throw new IllegalArgumentException("Cannot add clause " + clause + " to SpanNearQuery for field " + this.field);
            }
            this.clauses.add(clause);
            return this;
        }

        public Builder addGap(int width) {
            if (!this.ordered) {
                throw new IllegalArgumentException("Gaps can only be added to ordered near queries");
            }
            this.clauses.add(new SpanGapQuery(this.field, width));
            return this;
        }

        public Builder setSlop(int slop) {
            this.slop = slop;
            return this;
        }

        public SpanNearQuery build() {
            return new SpanNearQuery(this.clauses.toArray(new SpanQuery[this.clauses.size()]), this.slop, this.ordered);
        }
    }
}

