/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.spans.FilterSpans;
import org.apache.lucene.search.spans.ScoringWrapperSpans;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public final class SpanNotQuery
extends SpanQuery {
    private SpanQuery include;
    private SpanQuery exclude;
    private final int pre;
    private final int post;

    public SpanNotQuery(SpanQuery include, SpanQuery exclude) {
        this(include, exclude, 0, 0);
    }

    public SpanNotQuery(SpanQuery include, SpanQuery exclude, int dist) {
        this(include, exclude, dist, dist);
    }

    public SpanNotQuery(SpanQuery include, SpanQuery exclude, int pre, int post) {
        this.include = Objects.requireNonNull(include);
        this.exclude = Objects.requireNonNull(exclude);
        this.pre = pre >= 0 ? pre : 0;
        int n = this.post = post >= 0 ? post : 0;
        if (include.getField() != null && exclude.getField() != null && !include.getField().equals(exclude.getField())) {
            throw new IllegalArgumentException("Clauses must have same field.");
        }
    }

    public SpanQuery getInclude() {
        return this.include;
    }

    public SpanQuery getExclude() {
        return this.exclude;
    }

    @Override
    public String getField() {
        return this.include.getField();
    }

    @Override
    public String toString(String field2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanNot(");
        buffer.append(this.include.toString(field2));
        buffer.append(", ");
        buffer.append(this.exclude.toString(field2));
        buffer.append(", ");
        buffer.append(Integer.toString(this.pre));
        buffer.append(", ");
        buffer.append(Integer.toString(this.post));
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        SpanWeight includeWeight = this.include.createWeight(searcher, false);
        SpanWeight excludeWeight = this.exclude.createWeight(searcher, false);
        return new SpanNotWeight(searcher, needsScores ? SpanNotQuery.getTermContexts(includeWeight, excludeWeight) : null, includeWeight, excludeWeight);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        SpanQuery rewrittenInclude = (SpanQuery)this.include.rewrite(reader);
        SpanQuery rewrittenExclude = (SpanQuery)this.exclude.rewrite(reader);
        if (rewrittenInclude != this.include || rewrittenExclude != this.exclude) {
            return new SpanNotQuery(rewrittenInclude, rewrittenExclude, this.pre, this.post);
        }
        return super.rewrite(reader);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SpanNotQuery other = (SpanNotQuery)o;
        return this.include.equals(other.include) && this.exclude.equals(other.exclude) && this.pre == other.pre && this.post == other.post;
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = Integer.rotateLeft(h, 1);
        h ^= this.include.hashCode();
        h = Integer.rotateLeft(h, 1);
        h ^= this.exclude.hashCode();
        h = Integer.rotateLeft(h, 1);
        h ^= this.pre;
        h = Integer.rotateLeft(h, 1);
        return h ^= this.post;
    }

    public class SpanNotWeight
    extends SpanWeight {
        final SpanWeight includeWeight;
        final SpanWeight excludeWeight;

        public SpanNotWeight(IndexSearcher searcher, Map<Term, TermContext> terms, SpanWeight includeWeight, SpanWeight excludeWeight) throws IOException {
            super(SpanNotQuery.this, searcher, terms);
            this.includeWeight = includeWeight;
            this.excludeWeight = excludeWeight;
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            this.includeWeight.extractTermContexts(contexts);
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            Spans includeSpans = this.includeWeight.getSpans(context, requiredPostings);
            if (includeSpans == null) {
                return null;
            }
            final Spans excludeSpans = this.excludeWeight.getSpans(context, requiredPostings);
            if (excludeSpans == null) {
                return new ScoringWrapperSpans(includeSpans, this.getSimScorer(context));
            }
            final TwoPhaseIterator excludeTwoPhase = excludeSpans.asTwoPhaseIterator();
            final DocIdSetIterator excludeApproximation = excludeTwoPhase == null ? null : excludeTwoPhase.approximation();
            return new FilterSpans(includeSpans){
                int lastApproxDoc;
                boolean lastApproxResult;
                {
                    super(x0);
                    this.lastApproxDoc = -1;
                    this.lastApproxResult = false;
                }

                @Override
                protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
                    int doc = candidate.docID();
                    if (doc > excludeSpans.docID()) {
                        if (excludeTwoPhase != null) {
                            if (excludeApproximation.advance(doc) == doc) {
                                this.lastApproxDoc = doc;
                                this.lastApproxResult = excludeTwoPhase.matches();
                            }
                        } else {
                            excludeSpans.advance(doc);
                        }
                    } else if (excludeTwoPhase != null && doc == excludeSpans.docID() && doc != this.lastApproxDoc) {
                        this.lastApproxDoc = doc;
                        this.lastApproxResult = excludeTwoPhase.matches();
                    }
                    if (doc != excludeSpans.docID() || doc == this.lastApproxDoc && !this.lastApproxResult) {
                        return FilterSpans.AcceptStatus.YES;
                    }
                    if (excludeSpans.startPosition() == -1) {
                        excludeSpans.nextStartPosition();
                    }
                    while (excludeSpans.endPosition() <= candidate.startPosition() - SpanNotQuery.this.pre) {
                        if (excludeSpans.nextStartPosition() != Integer.MAX_VALUE) continue;
                        return FilterSpans.AcceptStatus.YES;
                    }
                    if (candidate.endPosition() + SpanNotQuery.this.post <= excludeSpans.startPosition()) {
                        return FilterSpans.AcceptStatus.YES;
                    }
                    return FilterSpans.AcceptStatus.NO;
                }
            };
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.includeWeight.extractTerms(terms);
        }
    }
}

