/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointDistanceQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQueryImpl;
import org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.lucene.spatial.util.GeoRect;
import org.apache.lucene.spatial.util.GeoRelationUtils;
import org.apache.lucene.util.SloppyMath;

final class GeoPointDistanceQueryImpl
extends GeoPointInBBoxQueryImpl {
    private final GeoPointDistanceQuery distanceQuery;
    private final double centerLon;

    GeoPointDistanceQueryImpl(String field2, GeoPointField.TermEncoding termEncoding, GeoPointDistanceQuery q, double centerLonUnwrapped, GeoRect bbox) {
        super(field2, termEncoding, bbox.minLon, bbox.minLat, bbox.maxLon, bbox.maxLat);
        this.distanceQuery = q;
        this.centerLon = centerLonUnwrapped;
    }

    @Override
    public void setRewriteMethod(MultiTermQuery.RewriteMethod method) {
        throw new UnsupportedOperationException("cannot change rewrite method");
    }

    @Override
    protected GeoPointMultiTermQuery.CellComparator newCellComparator() {
        return new GeoPointRadiusCellComparator(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoPointDistanceQueryImpl)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointDistanceQueryImpl that = (GeoPointDistanceQueryImpl)o;
        return this.distanceQuery.equals(that.distanceQuery);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.distanceQuery.hashCode();
        return result2;
    }

    public double getRadiusMeters() {
        return this.distanceQuery.getRadiusMeters();
    }

    private final class GeoPointRadiusCellComparator
    extends GeoPointMultiTermQuery.CellComparator {
        GeoPointRadiusCellComparator(GeoPointDistanceQueryImpl query) {
            super(query);
        }

        @Override
        protected boolean cellCrosses(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoRelationUtils.rectCrossesCircle(minLon, minLat, maxLon, maxLat, GeoPointDistanceQueryImpl.this.centerLon, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).distanceQuery.centerLat, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).distanceQuery.radiusMeters, true);
        }

        @Override
        protected boolean cellWithin(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoRelationUtils.rectWithinCircle(minLon, minLat, maxLon, maxLat, GeoPointDistanceQueryImpl.this.centerLon, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).distanceQuery.centerLat, ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).distanceQuery.radiusMeters, true);
        }

        @Override
        protected boolean cellIntersectsShape(double minLon, double minLat, double maxLon, double maxLat) {
            return this.cellCrosses(minLon, minLat, maxLon, maxLat);
        }

        @Override
        protected boolean postFilter(double lon, double lat) {
            return SloppyMath.haversin(((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).distanceQuery.centerLat, GeoPointDistanceQueryImpl.this.centerLon, lat, lon) * 1000.0 <= ((GeoPointDistanceQueryImpl)GeoPointDistanceQueryImpl.this).distanceQuery.radiusMeters;
        }
    }
}

