/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointDistanceQuery;

public final class GeoPointDistanceRangeQuery
extends GeoPointDistanceQuery {
    protected final double minRadiusMeters;

    public GeoPointDistanceRangeQuery(String field2, double centerLon, double centerLat, double minRadiusMeters, double maxRadiusMeters) {
        this(field2, GeoPointField.TermEncoding.PREFIX, centerLon, centerLat, minRadiusMeters, maxRadiusMeters);
    }

    public GeoPointDistanceRangeQuery(String field2, GeoPointField.TermEncoding termEncoding, double centerLon, double centerLat, double minRadiusMeters, double maxRadius) {
        super(field2, termEncoding, centerLon, centerLat, maxRadius);
        this.minRadiusMeters = minRadiusMeters;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query q = super.rewrite(reader);
        if (this.minRadiusMeters == 0.0) {
            return q;
        }
        BooleanQuery.Builder bqb = new BooleanQuery.Builder();
        GeoPointDistanceQuery exclude = new GeoPointDistanceQuery(this.field, this.termEncoding, this.centerLon, this.centerLat, this.minRadiusMeters);
        bqb.add(new BooleanClause(q, BooleanClause.Occur.MUST));
        bqb.add(new BooleanClause(exclude, BooleanClause.Occur.MUST_NOT));
        return bqb.build();
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field2)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        return sb.append(" Center: [").append(this.centerLon).append(',').append(this.centerLat).append(']').append(" From Distance: ").append(this.minRadiusMeters).append(" m").append(" To Distance: ").append(this.radiusMeters).append(" m").append(" Lower Left: [").append(this.minLon).append(',').append(this.minLat).append(']').append(" Upper Right: [").append(this.maxLon).append(',').append(this.maxLat).append("]").toString();
    }

    public double getMinRadiusMeters() {
        return this.minRadiusMeters;
    }

    public double getMaxRadiusMeters() {
        return this.radiusMeters;
    }
}

