/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.lucene.spatial.util.GeoRelationUtils;
import org.apache.lucene.util.SloppyMath;

class GeoPointInBBoxQueryImpl
extends GeoPointMultiTermQuery {
    GeoPointInBBoxQueryImpl(String field2, GeoPointField.TermEncoding termEncoding, double minLon, double minLat, double maxLon, double maxLat) {
        super(field2, termEncoding, minLon, minLat, maxLon, maxLat);
    }

    @Override
    public void setRewriteMethod(MultiTermQuery.RewriteMethod method) {
        throw new UnsupportedOperationException("cannot change rewrite method");
    }

    @Override
    protected short computeMaxShift() {
        double midLat = (this.minLat + this.maxLat) * 0.5;
        double midLon = (this.minLon + this.maxLon) * 0.5;
        int shiftFactor = SloppyMath.haversin(this.minLat, this.minLon, midLat, midLon) * 1000.0 > 1000000.0 ? 5 : 4;
        return (short)(9 * shiftFactor);
    }

    @Override
    protected GeoPointMultiTermQuery.CellComparator newCellComparator() {
        return new GeoPointInBBoxCellComparator(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointInBBoxQueryImpl that = (GeoPointInBBoxQueryImpl)o;
        if (Double.compare(that.maxLat, this.maxLat) != 0) {
            return false;
        }
        if (Double.compare(that.maxLon, this.maxLon) != 0) {
            return false;
        }
        if (Double.compare(that.minLat, this.minLat) != 0) {
            return false;
        }
        return Double.compare(that.minLon, this.minLon) == 0;
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        long temp = Double.doubleToLongBits(this.minLon);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLat);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLon);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLat);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.getField().equals(field2)) {
            sb.append(" field=");
            sb.append(this.getField());
            sb.append(':');
        }
        return sb.append(" Lower Left: [").append(this.minLon).append(',').append(this.minLat).append(']').append(" Upper Right: [").append(this.maxLon).append(',').append(this.maxLat).append("]").toString();
    }

    private final class GeoPointInBBoxCellComparator
    extends GeoPointMultiTermQuery.CellComparator {
        GeoPointInBBoxCellComparator(GeoPointMultiTermQuery query) {
            super(query);
        }

        @Override
        protected boolean cellCrosses(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoRelationUtils.rectCrosses(minLon, minLat, maxLon, maxLat, GeoPointInBBoxQueryImpl.this.minLon, GeoPointInBBoxQueryImpl.this.minLat, GeoPointInBBoxQueryImpl.this.maxLon, GeoPointInBBoxQueryImpl.this.maxLat);
        }

        @Override
        protected boolean cellWithin(double minLon, double minLat, double maxLon, double maxLat) {
            return GeoRelationUtils.rectWithin(minLon, minLat, maxLon, maxLat, GeoPointInBBoxQueryImpl.this.minLon, GeoPointInBBoxQueryImpl.this.minLat, GeoPointInBBoxQueryImpl.this.maxLon, GeoPointInBBoxQueryImpl.this.maxLat);
        }

        @Override
        protected boolean cellIntersectsShape(double minLon, double minLat, double maxLon, double maxLat) {
            return this.cellIntersectsMBR(minLon, minLat, maxLon, maxLat);
        }

        @Override
        protected boolean postFilter(double lon, double lat) {
            return GeoRelationUtils.pointInRectPrecise(lon, lat, GeoPointInBBoxQueryImpl.this.minLon, GeoPointInBBoxQueryImpl.this.minLat, GeoPointInBBoxQueryImpl.this.maxLon, GeoPointInBBoxQueryImpl.this.maxLat);
        }
    }
}

