/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointTermsEnum;
import org.apache.lucene.spatial.util.GeoEncodingUtils;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;

@Deprecated
final class GeoPointNumericTermsEnum
extends GeoPointTermsEnum {
    private final List<Range> rangeBounds = new LinkedList<Range>();
    private final short DETAIL_LEVEL = (short)((62 - this.maxShift) / 2);

    GeoPointNumericTermsEnum(TermsEnum tenum, GeoPointMultiTermQuery query) {
        super(tenum, query);
        this.computeRange(0L, (short)61);
        assert (!this.rangeBounds.isEmpty());
        Collections.sort(this.rangeBounds);
    }

    private final void computeRange(long term, short shift) {
        long split = term | 1L << shift;
        assert (shift < 64);
        long upperMax = shift < 63 ? term | (1L << shift + 1) - 1L : -1L;
        long lowerMax = split - 1L;
        this.relateAndRecurse(term, lowerMax, shift);
        this.relateAndRecurse(split, upperMax, shift);
    }

    private void relateAndRecurse(long start, long end, short res) {
        boolean within;
        double minLon = GeoEncodingUtils.mortonUnhashLon(start);
        double minLat = GeoEncodingUtils.mortonUnhashLat(start);
        double maxLon = GeoEncodingUtils.mortonUnhashLon(end);
        double maxLat = GeoEncodingUtils.mortonUnhashLat(end);
        short level = (short)(62 - res >>> 1);
        boolean bl = within = res % 9 == 0 && this.relationImpl.cellWithin(minLon, minLat, maxLon, maxLat);
        if (within || level == this.DETAIL_LEVEL && this.relationImpl.cellIntersectsShape(minLon, minLat, maxLon, maxLat)) {
            short nextRes = (short)(res - 1);
            if (nextRes % 9 == 0) {
                this.rangeBounds.add(new Range(start, nextRes, !within));
                this.rangeBounds.add(new Range(start | 1L << nextRes, nextRes, !within));
            } else {
                this.rangeBounds.add(new Range(start, res, !within));
            }
        } else if (level < this.DETAIL_LEVEL && this.relationImpl.cellIntersectsMBR(minLon, minLat, maxLon, maxLat)) {
            this.computeRange(start, (short)(res - 1));
        }
    }

    @Override
    protected final BytesRef peek() {
        this.rangeBounds.get(0).fillBytesRef(this.nextSubRangeBRB);
        return this.nextSubRangeBRB.get();
    }

    @Override
    protected void nextRange() {
        this.currentRange = this.rangeBounds.remove(0);
        super.nextRange();
    }

    @Override
    protected final BytesRef nextSeekTerm(BytesRef term) {
        while (this.hasNext()) {
            if (this.currentRange == null) {
                this.nextRange();
            }
            if (term != null && term.compareTo(this.currentCell) > 0) {
                this.nextRange();
                if (!this.rangeBounds.isEmpty()) continue;
            }
            return term != null && term.compareTo(this.currentCell) > 0 ? term : this.currentCell;
        }
        assert (this.rangeBounds.isEmpty());
        return null;
    }

    @Override
    protected final boolean hasNext() {
        return !this.rangeBounds.isEmpty();
    }

    protected final class Range
    extends GeoPointTermsEnum.BaseRange {
        Range(long lower, short shift, boolean boundary) {
            super(GeoPointNumericTermsEnum.this, lower, shift, boundary);
        }

        @Override
        protected void fillBytesRef(BytesRefBuilder result2) {
            assert (result2 != null);
            NumericUtils.longToPrefixCoded(this.start, this.shift, result2);
        }
    }
}

