/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.extractor.server;

import com.stratio.deep.commons.config.ExtractorConfig;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.exception.DeepInstantiationException;
import com.stratio.deep.commons.extractor.actions.Action;
import com.stratio.deep.commons.extractor.actions.GetPartitionsAction;
import com.stratio.deep.commons.extractor.actions.HasNextAction;
import com.stratio.deep.commons.extractor.actions.InitIteratorAction;
import com.stratio.deep.commons.extractor.actions.InitSaveAction;
import com.stratio.deep.commons.extractor.actions.NextAction;
import com.stratio.deep.commons.extractor.actions.SaveAction;
import com.stratio.deep.commons.extractor.response.CloseResponse;
import com.stratio.deep.commons.extractor.response.GetPartitionsResponse;
import com.stratio.deep.commons.extractor.response.HasNextResponse;
import com.stratio.deep.commons.extractor.response.InitIteratorResponse;
import com.stratio.deep.commons.extractor.response.InitSaveResponse;
import com.stratio.deep.commons.extractor.response.NextResponse;
import com.stratio.deep.commons.extractor.response.Response;
import com.stratio.deep.commons.extractor.response.SaveResponse;
import com.stratio.deep.commons.rdd.IExtractor;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.apache.spark.Partition;

public class ExtractorServerHandler<T>
extends SimpleChannelInboundHandler<Action> {
    private static final Logger LOG = Logger.getLogger(ExtractorServerHandler.class);
    private IExtractor<T, ExtractorConfig<T>> extractor;

    public void channelRead0(ChannelHandlerContext ctx, Action action) throws Exception {
        Response response = null;
        switch (action.getType()) {
            case GET_PARTITIONS: {
                GetPartitionsAction partitionsAction = (GetPartitionsAction)action;
                response = new GetPartitionsResponse(this.getPartitions(partitionsAction));
                break;
            }
            case CLOSE: {
                this.close();
                response = new CloseResponse();
                break;
            }
            case HAS_NEXT: {
                HasNextAction hasNextAction = (HasNextAction)action;
                response = new HasNextResponse(this.hastNext(hasNextAction));
                break;
            }
            case NEXT: {
                NextAction nextAction = (NextAction)action;
                response = new NextResponse<T>(this.next(nextAction));
                break;
            }
            case INIT_ITERATOR: {
                InitIteratorAction initIteratorAction = (InitIteratorAction)action;
                this.initIterator(initIteratorAction);
                response = new InitIteratorResponse();
                break;
            }
            case SAVE: {
                SaveAction SaveAction2 = (SaveAction)action;
                this.save(SaveAction2);
                response = new SaveResponse();
                break;
            }
            case INIT_SAVE: {
                InitSaveAction initSave = (InitSaveAction)action;
                this.initSave(initSave);
                response = new InitSaveResponse();
                break;
            }
        }
        ctx.write(response);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error((Object)cause.getMessage());
        ctx.close();
    }

    protected boolean hastNext(HasNextAction hasNextAction) {
        return this.extractor.hasNext();
    }

    protected T next(NextAction<T> nextAction) {
        return this.extractor.next();
    }

    protected void close() {
        this.extractor.close();
    }

    protected void initIterator(InitIteratorAction<T> initIteratorAction) {
        if (this.extractor == null) {
            this.initExtractor(initIteratorAction.getConfig());
        }
        this.extractor.initIterator(initIteratorAction.getPartition(), initIteratorAction.getConfig());
    }

    protected Partition[] getPartitions(GetPartitionsAction<T> getPartitionsAction) {
        if (this.extractor == null) {
            this.initExtractor(getPartitionsAction.getConfig());
        }
        return this.extractor.getPartitions(getPartitionsAction.getConfig());
    }

    private void initExtractor(ExtractorConfig<T> config) {
        try {
            Class<?> rdd = config.getExtractorImplClass();
            if (rdd == null) {
                rdd = Class.forName(config.getExtractorImplClassName());
            }
            Constructor<?> c = null;
            if (config.getEntityClass().isAssignableFrom(Cells.class)) {
                c = rdd.getConstructor(new Class[0]);
                this.extractor = (IExtractor)c.newInstance(new Object[0]);
            } else {
                c = rdd.getConstructor(Class.class);
                this.extractor = (IExtractor)c.newInstance(config.getEntityClass());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.error((Object)("Impossible to make an extractor instance, check classpath " + e.getMessage()));
            throw new DeepInstantiationException("Impossible to make an extractor instance, check classpath " + e.getMessage());
        }
    }

    protected void initSave(InitSaveAction<T> initSaveAction) {
        if (this.extractor == null) {
            this.initExtractor(initSaveAction.getConfig());
        }
        this.extractor.initSave(initSaveAction.getConfig(), initSaveAction.getFirst(), initSaveAction.getQueryBuilder());
    }

    protected void save(SaveAction<T> saveAction) {
        this.extractor.saveRDD(saveAction.getRecord());
    }
}

