/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.filter;

import com.stratio.deep.commons.filter.FilterType;
import java.io.Serializable;

public class Filter
implements Serializable {
    private static final long serialVersionUID = -3245502101559144688L;
    private final String field;
    private FilterType filterType;
    private Serializable value;

    public Filter(String field) {
        this.field = field;
    }

    public Filter(String field, FilterType filterType, Serializable value) {
        this.field = field;
        this.filterType = filterType;
        this.value = value;
    }

    public Filter greaterThan(Serializable value) {
        this.filterType = FilterType.GT;
        this.value = value;
        return this;
    }

    public Filter greaterThanEquals(Serializable value) {
        this.filterType = FilterType.GTE;
        this.value = value;
        return this;
    }

    public Filter lessThan(Serializable value) {
        this.filterType = FilterType.LT;
        this.value = value;
        return this;
    }

    public Filter lessThanEquals(Serializable value) {
        this.filterType = FilterType.LTE;
        this.value = value;
        return this;
    }

    public Filter notEquals(Serializable value) {
        this.filterType = FilterType.NEQ;
        this.value = value;
        return this;
    }

    public Filter is(Serializable value) {
        this.filterType = FilterType.EQ;
        this.value = value;
        return this;
    }

    public Filter match(Serializable value) {
        this.filterType = FilterType.MATCH;
        this.value = value;
        return this;
    }

    public Filter in(Serializable value) {
        this.filterType = FilterType.IN;
        this.value = value;
        return this;
    }

    public String getField() {
        return this.field;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public Serializable getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Filter{");
        sb.append("field='").append(this.field).append('\'');
        sb.append(", operation='").append((Object)this.filterType).append('\'');
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }
}

