/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.rdd;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class DeepTokenRange<T, K>
implements Comparable<DeepTokenRange>,
Serializable {
    private final T startToken;
    private final T endToken;
    private List<K> replicas;

    public DeepTokenRange(T startToken, T endToken) {
        this.startToken = startToken;
        this.endToken = endToken;
    }

    public DeepTokenRange(T startToken, T endToken, List<K> replicas) {
        this.startToken = startToken;
        this.endToken = endToken;
        this.replicas = replicas;
    }

    public DeepTokenRange(K[] replicas, T startToken, T endToken) {
        this.startToken = startToken;
        this.endToken = endToken;
        this.replicas = Arrays.asList(replicas);
    }

    public String toString() {
        return "DeepTokenRange{startToken=" + this.startToken + ", endToken=" + this.endToken + ", replicas=" + this.replicas + "}\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeepTokenRange that = (DeepTokenRange)o;
        if (!this.endToken.equals(that.endToken)) {
            return false;
        }
        return this.startToken.equals(that.startToken);
    }

    public int hashCode() {
        int result = this.startToken.hashCode();
        result = 31 * result + this.endToken.hashCode();
        return result;
    }

    public T getStartToken() {
        return this.startToken;
    }

    public T getStartTokenAsComparable() {
        return this.startToken;
    }

    public T getEndToken() {
        return this.endToken;
    }

    public T getEndTokenAsComparable() {
        return this.endToken;
    }

    public List<K> getReplicas() {
        return this.replicas;
    }

    @Override
    public int compareTo(DeepTokenRange o) {
        if (this.startToken instanceof Comparable) {
            return ((Comparable)this.startToken).compareTo(o.startToken);
        }
        return 0;
    }
}

