/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.utils;

import com.stratio.deep.commons.annotations.DeepField;
import com.stratio.deep.commons.entity.IDeepType;
import com.stratio.deep.commons.exception.DeepIOException;
import com.stratio.deep.commons.utils.Pair;
import com.stratio.deep.commons.utils.Utils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;

public final class AnnotationUtils {
    public static String deepFieldName(Field field) {
        DeepField annotation = field.getAnnotation(DeepField.class);
        if (StringUtils.isNotEmpty((String)annotation.fieldName())) {
            return annotation.fieldName();
        }
        return field.getName();
    }

    public static Field[] filterDeepFields(Class clazz) {
        Field[] fields = Utils.getAllFields(clazz);
        ArrayList<Field> filtered = new ArrayList<Field>();
        for (Field f : fields) {
            if (!f.isAnnotationPresent(DeepField.class)) continue;
            filtered.add(f);
        }
        return filtered.toArray(new Field[filtered.size()]);
    }

    public static Pair<Field[], Field[]> filterKeyFields(Class clazz) {
        Field[] filtered = AnnotationUtils.filterDeepFields(clazz);
        ArrayList<Field> keys = new ArrayList<Field>();
        ArrayList<Field> others = new ArrayList<Field>();
        for (Field field : filtered) {
            if (AnnotationUtils.isKey(field.getAnnotation(DeepField.class))) {
                keys.add(field);
                continue;
            }
            others.add(field);
        }
        return Pair.create(keys.toArray(new Field[keys.size()]), others.toArray(new Field[others.size()]));
    }

    public static boolean isKey(DeepField field) {
        return field.isPartOfClusterKey() || field.isPartOfPartitionKey();
    }

    public static Serializable getBeanFieldValue(IDeepType entity, Field deepField) {
        try {
            return (Serializable)PropertyUtils.getProperty((Object)entity, (String)deepField.getName());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
            throw new DeepIOException(e1);
        }
    }

    public static Class[] getGenericTypes(Field field) {
        try {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            Type[] types = type.getActualTypeArguments();
            Class[] res = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                res[i] = (Class)types[i];
            }
            return res;
        }
        catch (ClassCastException e) {
            return new Class[]{(Class)field.getGenericType()};
        }
    }

    private AnnotationUtils() {
    }
}

