/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.utils;

import com.stratio.deep.commons.config.BaseConfig;
import com.stratio.deep.commons.config.DeepJobConfig;
import com.stratio.deep.commons.config.ExtractorConfig;
import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.entity.IDeepType;
import com.stratio.deep.commons.exception.DeepExtractorInitializationException;
import com.stratio.deep.commons.exception.DeepGenericException;
import com.stratio.deep.commons.exception.DeepIOException;
import com.stratio.deep.commons.rdd.IExtractor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import scala.Tuple2;

public final class Utils {
    private static final transient Logger LOG = Logger.getLogger(Utils.class);

    public static <T extends IDeepType> T newTypeInstance(Class<T> clazz) {
        try {
            return (T)((IDeepType)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DeepGenericException(e);
        }
    }

    public static <T> T newTypeInstance(String className, Class<T> returnClass) {
        try {
            Class<?> clazz = Class.forName(className);
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new DeepGenericException(e);
        }
    }

    public static String quote(String identifier) {
        if (StringUtils.isEmpty((String)identifier)) {
            return identifier;
        }
        String res = identifier.trim();
        if (!res.startsWith("\"")) {
            res = "\"" + res;
        }
        if (!res.endsWith("\"")) {
            res = res + "\"";
        }
        return res;
    }

    public static String singleQuote(String identifier) {
        if (StringUtils.isEmpty((String)identifier)) {
            return identifier;
        }
        String res = identifier.trim();
        if (!res.startsWith("'")) {
            res = "'" + res;
        }
        if (!res.endsWith("'")) {
            res = res + "'";
        }
        return res;
    }

    public static String batchQueryGenerator(List<String> statements) {
        StringBuilder sb = new StringBuilder("BEGIN BATCH \n");
        for (String statement : statements) {
            sb.append(statement).append("\n");
        }
        sb.append(" APPLY BATCH;");
        return sb.toString();
    }

    public static Tuple2<String[], Object[]> prepareTuple4CqlDriver(Tuple2<Cells, Cells> tuple) {
        Cell cell;
        Cells keys = (Cells)tuple._1();
        Cells columns = (Cells)tuple._2();
        String[] names = new String[keys.size() + columns.size()];
        Object[] values = new Object[keys.size() + columns.size()];
        for (int k = 0; k < keys.size(); ++k) {
            cell = keys.getCellByIdx(k);
            names[k] = Utils.quote(cell.getCellName());
            values[k] = cell.getCellValue();
        }
        for (int v = keys.size(); v < keys.size() + columns.size(); ++v) {
            cell = columns.getCellByIdx(v - keys.size());
            names[v] = Utils.quote(cell.getCellName());
            values[v] = cell.getCellValue();
        }
        return new Tuple2((Object)names, (Object)values);
    }

    public static Method findSetter(String propertyName, Class entityClass, Class valueType) {
        Method setter;
        String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            setter = entityClass.getMethod(setterName, valueType);
        }
        catch (NoSuchMethodException e) {
            try {
                setter = entityClass.getMethod(propertyName + "_$eq", valueType);
            }
            catch (NoSuchMethodException e1) {
                throw new DeepIOException(e1);
            }
        }
        return setter;
    }

    public static boolean setFieldWithReflection(Object object, String fieldName, Object fieldValue) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(object, fieldValue);
                return true;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return false;
    }

    public static Method findGetter(String propertyName, Class entityClass) {
        Method getter;
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            getter = entityClass.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                getter = entityClass.getMethod(propertyName + "_$eq", new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw new DeepIOException(e1);
            }
        }
        return getter;
    }

    public static InetAddress inetAddressFromLocation(String location) {
        try {
            return InetAddress.getByName(location);
        }
        catch (UnknownHostException e) {
            throw new DeepIOException(e);
        }
    }

    public static Field[] getAllFields(Class clazz) {
        return Utils.getAllFieldsRec(clazz, new ArrayList<Field>());
    }

    private static Field[] getAllFieldsRec(Class clazz, List<Field> fields) {
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            Utils.getAllFieldsRec(superClazz, fields);
        }
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return fields.toArray(new Field[fields.size()]);
    }

    private Utils() {
    }

    public static List<String> removeAddressPort(List<String> stringList) {
        ArrayList<String> adresNoPort = new ArrayList<String>();
        for (String s : stringList) {
            int index = s.indexOf(":");
            if (index > -1) {
                adresNoPort.add(s.substring(0, index));
                continue;
            }
            adresNoPort.add(s);
        }
        return adresNoPort;
    }

    public static String splitListByComma(List<String> hosts) {
        boolean firstHost = true;
        StringBuilder hostConnection = new StringBuilder();
        for (String host : hosts) {
            if (!firstHost) {
                hostConnection.append(",");
            }
            hostConnection.append(host.trim());
            firstHost = false;
        }
        return hostConnection.toString();
    }

    public static <T, S extends BaseConfig> IExtractor<T, S> getExtractorInstance(S config) {
        try {
            Class<?> rdd = config.getExtractorImplClass();
            if (rdd == null) {
                rdd = Class.forName(config.getExtractorImplClassName());
            }
            if (config.getEntityClass().isAssignableFrom(Cells.class)) {
                Constructor<?> c = rdd.getConstructor(new Class[0]);
                return (IExtractor)c.newInstance(new Object[0]);
            }
            Constructor<?> c = rdd.getConstructor(Class.class);
            return (IExtractor)c.newInstance(config.getEntityClass());
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            String message = "A exception happens and we wrap with DeepExtractorInitializationException" + e.getMessage();
            LOG.error((Object)message);
            throw new DeepExtractorInitializationException(message, e);
        }
    }

    public static Object castNumberType(Object object, Class clazz) {
        if (Number.class.isAssignableFrom(clazz)) {
            if (Double.class.isAssignableFrom(clazz)) {
                return ((Number)object).doubleValue();
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return ((Number)object).longValue();
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return Float.valueOf(((Number)object).floatValue());
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return ((Number)object).intValue();
            }
            if (Short.class.isAssignableFrom(clazz)) {
                return ((Number)object).shortValue();
            }
            if (Byte.class.isAssignableFrom(clazz)) {
                return ((Number)object).byteValue();
            }
            if (BigInteger.class.isAssignableFrom(clazz)) {
                return BigInteger.valueOf(((Number)object).longValue());
            }
            if (BigDecimal.class.isAssignableFrom(clazz)) {
                return BigDecimal.valueOf(((Number)object).longValue());
            }
            if (AtomicLong.class.isAssignableFrom(clazz)) {
                return new AtomicLong(((Number)object).longValue());
            }
            if (AtomicInteger.class.isAssignableFrom(clazz)) {
                return new AtomicInteger(((Number)object).intValue());
            }
        }
        throw new ClassCastException("it is not a Number Type" + object.getClass() + "|" + clazz);
    }

    public static Object castingUtil(String value, Class classCasting) {
        String object = value;
        if (Number.class.isAssignableFrom(classCasting)) {
            if (classCasting.isAssignableFrom(Double.class)) {
                return Double.valueOf(value);
            }
            if (classCasting.isAssignableFrom(Long.class)) {
                return Long.valueOf(value);
            }
            if (classCasting.isAssignableFrom(Float.class)) {
                return Float.valueOf(value);
            }
            if (classCasting.isAssignableFrom(Integer.class)) {
                return Integer.valueOf(value);
            }
            if (classCasting.isAssignableFrom(Short.class)) {
                return Short.valueOf(value);
            }
            if (classCasting.isAssignableFrom(Byte.class)) {
                return Byte.valueOf(value);
            }
        } else if (String.class.isAssignableFrom(classCasting)) {
            return object.toString();
        }
        return null;
    }

    public static <S extends BaseConfig, W extends DeepJobConfig> W initConfig(S config, W deepJobConfig) {
        if (config instanceof ExtractorConfig) {
            deepJobConfig.initialize((ExtractorConfig)config);
        } else if (deepJobConfig.getClass().isAssignableFrom(config.getClass())) {
            deepJobConfig = ((DeepJobConfig)config).initialize();
        } else {
            deepJobConfig.initialize((DeepJobConfig)config);
        }
        return deepJobConfig;
    }

    public static <T> T cloneObjectWithParents(T t) throws IllegalAccessException, InstantiationException {
        Object clone = t.getClass().newInstance();
        ArrayList allFields = new ArrayList();
        for (Class<?> parentClass = t.getClass().getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            Collections.addAll(allFields, parentClass.getDeclaredFields());
        }
        Collections.addAll(allFields, t.getClass().getDeclaredFields());
        for (Field field : allFields) {
            int modifiers = field.getModifiers();
            if ((0x10 & modifiers) != 0 || (8 & modifiers) != 0) continue;
            field.setAccessible(true);
            Object value = field.get(t);
            if (Collection.class.isAssignableFrom(field.getType())) {
                Collection collection = (Collection)field.get(clone);
                if (collection == null) {
                    collection = (Collection)field.get(t).getClass().newInstance();
                }
                collection.addAll((Collection)field.get(t));
                value = collection;
            } else if (Map.class.isAssignableFrom(field.getType())) {
                Map clonMap = (Map)field.get(t).getClass().newInstance();
                clonMap.putAll((Map)field.get(t));
                value = clonMap;
            }
            field.set(clone, value);
        }
        return (T)clone;
    }

    public static ExecutorService newBlockingFixedThreadPoolExecutor(int nThreads, int queueSize) {
        ArrayBlockingQueue<Runnable> blockingQueue = new ArrayBlockingQueue<Runnable>(queueSize);
        RejectedExecutionHandler blockingRejectedExecutionHandler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
                try {
                    executor.getQueue().put(task);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, blockingQueue, blockingRejectedExecutionHandler);
    }
}

