/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.mojo.unix.maven;

import com.stratio.mojo.unix.FileAttributes;
import com.stratio.mojo.unix.FileCollector;
import com.stratio.mojo.unix.MissingSettingException;
import com.stratio.mojo.unix.PackageParameters;
import com.stratio.mojo.unix.PackageVersion;
import com.stratio.mojo.unix.UnixPackage;
import com.stratio.mojo.unix.core.AssemblyOperation;
import com.stratio.mojo.unix.core.UnixPlatform;
import com.stratio.mojo.unix.io.fs.LocalFs;
import com.stratio.mojo.unix.java.StringF;
import com.stratio.mojo.unix.maven.plugin.AssemblyOp;
import com.stratio.mojo.unix.maven.plugin.CopyDirectory;
import com.stratio.mojo.unix.maven.plugin.Defaults;
import com.stratio.mojo.unix.maven.plugin.MavenProjectWrapper;
import com.stratio.mojo.unix.maven.plugin.Package;
import com.stratio.mojo.unix.maven.plugin.PackagingFormat;
import com.stratio.mojo.unix.maven.plugin.PackagingMojoParameters;
import com.stratio.mojo.unix.maven.plugin.UnknownArtifactException;
import com.stratio.mojo.unix.util.FileModulator;
import com.stratio.mojo.unix.util.ScriptUtil;
import com.stratio.mojo.unix.util.line.AbstractLineStreamWriter;
import com.stratio.mojo.unix.util.line.LineStreamWriter;
import fj.F;
import fj.F2;
import fj.Function;
import fj.Ord;
import fj.P;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.data.List;
import fj.data.Option;
import fj.data.Set;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MojoHelper {
    public static final String ATTACHED_NO_ARTIFACTS_CONFIGURED = "When running in attached mode at least one package has to be configured.";
    public static final String DUPLICATE_CLASSIFIER = "Duplicate package classifier: '%s'.";
    public static final String DUPLICATE_UNCLASSIFIED = "There can only be one package without an classifier.";
    static F<String, String> dashString = Function.curry((F2)StringF.concat, (Object)"-");

    public static <UP extends UnixPackage<UP, PP>, PP extends UnixPackage.PreparedPackage> Execution create(Map platforms, String platformType, String formatType, MavenProjectWrapper project, boolean debug, boolean attachedMode, F<UP, UP> validateMojoSettingsAndApplyFormatSpecificSettingsToPackage, PackagingMojoParameters mojoParameters, final Log log) throws MojoFailureException, MojoExecutionException {
        PackagingFormat format = PackagingFormat.lookup(formatType);
        if (format == null) {
            throw new MojoFailureException("INTERNAL ERROR: could not find format: '" + formatType + "'.");
        }
        UnixPlatform platform = (UnixPlatform)platforms.get(platformType);
        if (platform == null) {
            throw new MojoFailureException("INTERNAL ERROR: could not find platform: '" + platformType + "'.");
        }
        SimpleDateFormat utcDateFormatter = new SimpleDateFormat("yyyyMMdd.HHmmss");
        utcDateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String timestamp = utcDateFormatter.format(new Date());
        LocalFs buildDirectory = new LocalFs(project.buildDirectory);
        PackageVersion version = PackageVersion.packageVersion((String)project.version, (String)timestamp, (boolean)project.artifact.isSnapshot(), mojoParameters.revision);
        List packages = List.nil();
        for (Package pakke : MojoHelper.validatePackages(mojoParameters.packages, attachedMode)) {
            try {
                String name = "unix/root-" + formatType + (String)pakke.classifier.map(dashString).orSome((Object)"");
                LocalFs packageRoot = buildDirectory.resolve(name);
                packageRoot.mkdir();
                PackageParameters parameters = MojoHelper.calculatePackageParameters(project, version, platform, mojoParameters, pakke);
                UnixPackage unixPackage = ((UnixPackage)format.start(log)).parameters(parameters).setVersion(version).workingDirectory(packageRoot).debug(debug).basedir(project.basedir);
                unixPackage = (UnixPackage)validateMojoSettingsAndApplyFormatSpecificSettingsToPackage.f((Object)unixPackage);
                List<AssemblyOperation> assemblyOperations = MojoHelper.createAssemblyOperations(project, parameters, unixPackage, project.basedir, buildDirectory, mojoParameters.assembly, pakke.assembly);
                if (debug) {
                    log.info((CharSequence)"=======================================================================");
                    log.info((CharSequence)("Package parameters: " + parameters.id));
                    log.info((CharSequence)"Default file attributes: ");
                    log.info((CharSequence)(" File      : " + parameters.defaultFileAttributes));
                    log.info((CharSequence)(" Directory : " + parameters.defaultDirectoryAttributes));
                    log.info((CharSequence)"Assembly operations: ");
                    for (AssemblyOperation operation : assemblyOperations) {
                        operation.streamTo((LineStreamWriter)new AbstractLineStreamWriter(){

                            protected void onLine(String line) {
                                log.info((CharSequence)line);
                            }
                        });
                    }
                }
                packages = packages.cons((Object)P.p((Object)unixPackage, (Object)pakke, assemblyOperations));
            }
            catch (UnknownArtifactException e) {
                TreeMap<String, Artifact> map = new TreeMap<String, Artifact>(e.artifactMap);
                log.warn((CharSequence)("Could not find artifact:" + e.artifact));
                log.warn((CharSequence)"Available artifacts:");
                for (Object o : map.keySet()) {
                    log.warn((CharSequence)o.toString());
                }
                throw new MojoFailureException("Unable to find artifact: '" + e.artifact + "'. See log for available artifacts.");
            }
            catch (MissingSettingException e) {
                String msg = "Missing required setting '" + e.getSetting() + "'";
                if (!pakke.classifier.isNone()) {
                    msg = msg + ", for '" + (String)pakke.classifier.some() + "'";
                }
                msg = msg + ", format '" + formatType + "'.";
                throw new MojoFailureException(msg);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating package " + (pakke.classifier.isSome() ? "classifier '" + pakke.classifier + "'" : "") + ", format '" + formatType + "'.", (Exception)e);
            }
        }
        return new Execution(packages, project, formatType, attachedMode);
    }

    public static PackageParameters calculatePackageParameters(final MavenProjectWrapper project, PackageVersion version, UnixPlatform platform, final PackagingMojoParameters mojoParameters, final Package pakke) {
        String id = (String)pakke.id.orSome((P1)new P1<String>(){

            public String _1() {
                if (((String)mojoParameters.outputFileName.orSome((Object)"")).isEmpty()) {
                    return project.artifactId + (String)pakke.classifier.map(dashString).orSome((Object)"");
                }
                return (String)mojoParameters.outputFileName.some();
            }
        });
        P2<FileAttributes, FileAttributes> defaultFileAttributes = MojoHelper.calculateDefaultFileAttributes(platform, mojoParameters.defaults, pakke.defaults);
        String name = (String)pakke.name.orElse(mojoParameters.name).orSome((Object)project.name);
        return PackageParameters.packageParameters((String)project.groupId, (String)project.artifactId, (PackageVersion)version, (String)id, (String)name, pakke.classifier, (FileAttributes)((FileAttributes)defaultFileAttributes._1()), (FileAttributes)((FileAttributes)defaultFileAttributes._2())).description(pakke.description.orElse(mojoParameters.description).orElse(project.description)).contact(mojoParameters.contact).size(mojoParameters.size).contactEmail(mojoParameters.contactEmail).license(MojoHelper.getLicense(project)).architecture(pakke.architecture.orElse(mojoParameters.architecture)).excludeDirs(mojoParameters.excludeDirs);
    }

    public static P2<FileAttributes, FileAttributes> calculateDefaultFileAttributes(UnixPlatform platform, Defaults mojo, Defaults pakke) {
        return P.p((Object)MojoHelper.calculateFileAttributes(platform.getDefaultFileAttributes(), mojo.fileAttributes.create(), pakke.fileAttributes.create()), (Object)MojoHelper.calculateFileAttributes(platform.getDefaultDirectoryAttributes(), mojo.directoryAttributes.create(), pakke.directoryAttributes.create()));
    }

    public static FileAttributes calculateFileAttributes(FileAttributes platform, FileAttributes mojo, FileAttributes pakke) {
        return platform.useAsDefaultsFor(mojo).useAsDefaultsFor(pakke);
    }

    public static List<AssemblyOperation> createAssemblyOperations(MavenProjectWrapper project, PackageParameters parameters, UnixPackage unixPackage, File basedir, LocalFs buildDirectory, List<AssemblyOp> mojoAssembly, List<AssemblyOp> packageAssembly) throws IOException, MojoFailureException, UnknownArtifactException {
        unixPackage.beforeAssembly(parameters.defaultDirectoryAttributes, project.timestamp);
        String unix = new File(basedir, "src/main/unix/files").getAbsolutePath();
        String classifierOrDefault = (String)parameters.classifier.orSome((Object)"default");
        List defaultAssemblyOp = List.nil();
        for (String s : FileModulator.modulatePath((String)classifierOrDefault, (String)unixPackage.getPackageFileExtension(), (String)unix)) {
            File file = new File(s);
            if (!file.isDirectory()) continue;
            CopyDirectory op = new CopyDirectory();
            op.setFrom(file);
            defaultAssemblyOp = defaultAssemblyOp.cons((Object)op);
        }
        List list = List.single((Object)defaultAssemblyOp.reverse()).conss(mojoAssembly).conss(packageAssembly);
        List assemblyOps = List.join((List)list.reverse());
        List operations = List.nil();
        AssemblyOp.CreateOperationContext context = new AssemblyOp.CreateOperationContext(buildDirectory, parameters.defaultFileAttributes, parameters.defaultDirectoryAttributes, project);
        for (AssemblyOp assemblyOp : assemblyOps) {
            operations = operations.cons((Object)assemblyOp.createOperation(context));
        }
        return operations.reverse();
    }

    public static List<Package> validatePackages(List<Package> packages, boolean attachedMode) throws MojoFailureException {
        if (packages.isEmpty()) {
            packages = List.single((Object)new Package());
        }
        Set names = Set.empty((Ord)Ord.stringOrd);
        List outPackages = List.nil();
        Option defaultPackage = Option.none();
        for (Package pakke : packages) {
            if (pakke.classifier.exists(Function.curry((F2)StringF.equals, (Object)"default"))) {
                pakke.classifier = Option.none();
            }
            if (pakke.classifier.isNone()) {
                if (defaultPackage.isSome()) {
                    throw new MojoFailureException(DUPLICATE_UNCLASSIFIED);
                }
                defaultPackage = Option.some((Object)pakke);
                continue;
            }
            if (names.member(pakke.classifier.some())) {
                throw new MojoFailureException(String.format(DUPLICATE_CLASSIFIER, pakke.classifier));
            }
            names = names.insert(pakke.classifier.some());
            outPackages = outPackages.cons((Object)pakke);
        }
        if (attachedMode) {
            outPackages = defaultPackage.toList().append(outPackages);
            if (outPackages.isEmpty()) {
                throw new MojoFailureException(ATTACHED_NO_ARTIFACTS_CONFIGURED);
            }
            return outPackages;
        }
        if (defaultPackage.isNone()) {
            throw new MojoFailureException("When running in 'primary artifact mode' either one package has to have 'default' as classifier or there has to be one without any classifier.");
        }
        return defaultPackage.toList().append(outPackages);
    }

    private static Option<String> getLicense(MavenProjectWrapper project) {
        if (project.licenses.size() == 0) {
            return Option.none();
        }
        return Option.some((Object)project.licenses.get(0).getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Execution<UP extends UnixPackage> {
        private final List<P3<UP, Package, List<AssemblyOperation>>> packages;
        private final MavenProjectWrapper project;
        private final String formatType;
        private final boolean attachedMode;

        public Execution(List<P3<UP, Package, List<AssemblyOperation>>> packages, MavenProjectWrapper project, String formatType, boolean attachedMode) {
            this.packages = packages;
            this.project = project;
            this.formatType = formatType;
            this.attachedMode = attachedMode;
        }

        public void execute(String artifactType, MavenProject mavenProject, MavenProjectHelper mavenProjectHelper, ScriptUtil.Strategy strategy) throws MojoExecutionException, MojoFailureException {
            for (P3 p : this.packages) {
                UnixPackage unixPackage = (UnixPackage)p._1();
                Package pakke = (Package)p._2();
                try {
                    for (AssemblyOperation assemblyOperation : (List)p._3()) {
                        assemblyOperation.perform((FileCollector)unixPackage);
                    }
                    String version = unixPackage.getVersion().getMavenVersion();
                    if (unixPackage.getPackageFileExtension().equals("rpm")) {
                        version = version.replace('-', '_');
                    }
                    String architecture = "";
                    if (StringUtils.isNotEmpty((String)unixPackage.getArchitecture())) {
                        architecture = unixPackage.getArchitecture() + ".";
                    }
                    String baseName = null;
                    baseName = StringUtils.isNotEmpty((String)unixPackage.getOutputFileName()) ? unixPackage.getOutputFileName() : this.project.outputFileName;
                    String name = baseName + (String)pakke.classifier.map(dashString).orSome((Object)"") + "-" + version + "." + architecture + unixPackage.getPackageFileExtension();
                    File packageFile = new File(this.project.buildDirectory, name);
                    unixPackage.prepare(strategy).packageToFile(packageFile);
                    this.attach(pakke.classifier, artifactType, packageFile, mavenProject, mavenProjectHelper, this.attachedMode);
                }
                catch (MojoExecutionException e) {
                    throw e;
                }
                catch (MojoFailureException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to create package.", e);
                }
            }
        }

        private void attach(Option<String> classifier, String artifactType, File packageFile, MavenProject project, MavenProjectHelper mavenProjectHelper, boolean attachedMode) {
            if (attachedMode) {
                if (classifier.isSome()) {
                    mavenProjectHelper.attachArtifact(project, artifactType, (String)classifier.some(), packageFile);
                } else {
                    mavenProjectHelper.attachArtifact(project, artifactType, null, packageFile);
                }
            } else if (classifier.isNone()) {
                project.getArtifact().setFile(packageFile);
            } else {
                mavenProjectHelper.attachArtifact(project, this.formatType, (String)classifier.some(), packageFile);
            }
        }
    }
}

