/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.mojo.unix.maven.deb;

import com.stratio.mojo.unix.FileAttributes;
import com.stratio.mojo.unix.PackageParameters;
import com.stratio.mojo.unix.PackageVersion;
import com.stratio.mojo.unix.UnixFsObject;
import com.stratio.mojo.unix.UnixPackage;
import com.stratio.mojo.unix.core.FsFileCollector;
import com.stratio.mojo.unix.deb.ControlFile;
import com.stratio.mojo.unix.deb.DpkgDeb;
import com.stratio.mojo.unix.io.fs.Fs;
import com.stratio.mojo.unix.io.fs.LocalFs;
import com.stratio.mojo.unix.util.RelativePath;
import com.stratio.mojo.unix.util.ScriptUtil;
import com.stratio.mojo.unix.util.UnixUtil;
import com.stratio.mojo.unix.util.line.LineStreamUtil;
import com.stratio.mojo.unix.util.line.LineStreamWriter;
import fj.F;
import fj.data.List;
import fj.data.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import org.joda.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebUnixPackage
extends UnixPackage<DebUnixPackage, DebPreparedPackage> {
    private ControlFile controlFile;
    private FsFileCollector fileCollector;
    private boolean useFakeroot;
    private Option<String> dpkgDeb;
    private boolean debug;
    private static final ScriptUtil scriptUtil = new ScriptUtil("preinst", "postinst", "prerm", "postrm");

    public DebUnixPackage() {
        super("deb");
    }

    public DebUnixPackage parameters(PackageParameters parameters) {
        this.controlFile = new ControlFile((String)parameters.outputFileName.orSome((Object)parameters.id)).version(Option.some((Object)DebUnixPackage.getDebianVersion(parameters.version))).description(DebUnixPackage.getDescription(parameters)).maintainer(parameters.contact).installedSize(parameters.size).architecture(parameters.architecture.orElse(Option.some((Object)"all")));
        return this;
    }

    public DebUnixPackage debParameters(Option<String> priority, Option<String> section, boolean useFakeroot, Option<String> dpkgDeb, List<String> depends, List<String> recommends, List<String> suggests, List<String> preDepends, List<String> provides, List<String> replaces) {
        this.useFakeroot = useFakeroot;
        this.dpkgDeb = dpkgDeb;
        this.controlFile = this.controlFile.priority(priority).section(section).depends(depends).recommends(recommends).suggests(suggests).preDepends(preDepends).provides(provides).replaces(replaces);
        return this;
    }

    public DebUnixPackage debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public void beforeAssembly(FileAttributes defaultDirectoryAttributes, LocalDateTime timestamp) throws IOException {
        this.fileCollector = new FsFileCollector(this.workingDirectory.resolve(RelativePath.relativePath((String)"assembly")));
    }

    public void addDirectory(UnixFsObject.Directory directory) {
        this.fileCollector.addDirectory(directory);
    }

    public void addFile(Fs<?> fromFile, UnixFsObject.RegularFile file) throws IOException {
        this.fileCollector.addFile(fromFile, file);
    }

    public void addSymlink(UnixFsObject.Symlink symlink) throws IOException {
        this.fileCollector.addSymlink(symlink);
    }

    public void apply(F<UnixFsObject, Option<UnixFsObject>> f) {
        this.fileCollector.apply(f);
    }

    public DebPreparedPackage prepare(ScriptUtil.Strategy strategy) throws Exception {
        LocalFs debian = this.fileCollector.root.resolve(RelativePath.relativePath((String)"DEBIAN"));
        LocalFs controlFilePath = debian.resolve(RelativePath.relativePath((String)"control"));
        debian.mkdir();
        LineStreamUtil.toFile((List)this.controlFile.toList(), (File)controlFilePath.file);
        this.fileCollector.collect();
        ScriptUtil.Result result = scriptUtil.createExecution(this.controlFile.packageName, "deb", this.getScripts(), debian.file, strategy).execute();
        try {
            LocalFs conffilesFilePath = debian.resolve(RelativePath.relativePath((String)"conffiles"));
            conffilesFilePath.file.setExecutable(false, false);
            conffilesFilePath.file.setReadable(true, false);
            conffilesFilePath.file.setWritable(false, false);
            conffilesFilePath.file.setWritable(true, true);
        }
        catch (Exception e) {
            System.out.println("conffiles is not accessible");
        }
        return new DebPreparedPackage(result);
    }

    public String getArchitecture() {
        return (String)this.controlFile.architecture.some();
    }

    public String getOutputFileName() {
        return this.controlFile.packageName;
    }

    public static Option<String> getDescription(PackageParameters parameters) {
        String debianDescription;
        String description = parameters.name.trim();
        if (parameters.description.isSome()) {
            description = description + LineStreamWriter.EOL + ((String)parameters.description.some()).trim();
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(description.trim()));
            debianDescription = reader.readLine();
            String line = reader.readLine();
            if (line != null) {
                debianDescription = debianDescription + LineStreamWriter.EOL + " " + line.trim();
                line = reader.readLine();
            }
            while (line != null) {
                debianDescription = (line = line.trim()).equals("") ? debianDescription + LineStreamWriter.EOL + "." : debianDescription + LineStreamWriter.EOL + " " + line;
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error", e);
        }
        return Option.some((Object)debianDescription);
    }

    public static String getDebianVersion(PackageVersion version) {
        String v = version.version;
        String r = (String)version.revision.orSome((Object)"1");
        int index = v.indexOf(45);
        if (index != -1 && index < v.length() - 1 && Character.isLetter(v.charAt(index + 1))) {
            v = v.replaceFirst("-", "~");
        }
        if (!version.snapshot) {
            return v;
        }
        return v + "~" + version.timestamp;
    }

    public class DebPreparedPackage
    extends UnixPackage.PreparedPackage {
        private final ScriptUtil.Result result;

        DebPreparedPackage(ScriptUtil.Result result) {
            super((UnixPackage)DebUnixPackage.this);
            this.result = result;
        }

        public void packageToFile(File packageFile) throws Exception {
            UnixUtil.chmodIf((Option)this.result.preInstall, (String)"0755");
            UnixUtil.chmodIf((Option)this.result.postInstall, (String)"0755");
            UnixUtil.chmodIf((Option)this.result.preRemove, (String)"0755");
            UnixUtil.chmodIf((Option)this.result.postRemove, (String)"0755");
            new DpkgDeb().setDebug(DebUnixPackage.this.debug).setPackageRoot(((DebUnixPackage)DebUnixPackage.this).fileCollector.root.file).setDebFile(packageFile).setUseFakeroot(DebUnixPackage.this.useFakeroot).setDpkgDeb(DebUnixPackage.this.dpkgDeb).execute();
        }
    }
}

